/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.skin.variant.HumanoidSkinVariant;
import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.utils.TextUtils;
import java.util.EnumMap;
import java.util.Locale;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;

public interface VariantDataCapable<T extends PathfinderMob>
extends EasyNPC<T> {
    public static final String EASY_NPC_DATA_VARIANT_TYPE_TAG = "VariantType";

    public static void registerSyncedVariantData(EnumMap<SynchedDataIndex, EntityDataAccessor<?>> map, Class<? extends Entity> entityClass) {
        log.info("- Registering Synched Variant Type Data for {}.", (Object)entityClass.getSimpleName());
        map.put(SynchedDataIndex.VARIANT_TYPE, SynchedEntityData.m_135353_(entityClass, (EntityDataSerializer)EntityDataSerializers.f_135030_));
    }

    default public Enum<?> getDefaultSkinVariantType() {
        return HumanoidSkinVariant.STEVE;
    }

    default public Enum<?> getSkinVariantType() {
        return this.getSkinVariantType((String)this.getSynchedEntityData(SynchedDataIndex.VARIANT_TYPE));
    }

    default public void setSkinVariantType(Enum<?> variant) {
        if (this.getSkinVariantType() != variant) {
            this.setSynchedEntityData(SynchedDataIndex.VARIANT_TYPE, variant != null ? variant.name() : "");
            this.handleSkinVariantTypeChange(variant);
        }
    }

    default public void setSkinVariantType(String name) {
        Enum<?> variantType = this.getSkinVariantType(name);
        if (variantType != null) {
            this.setSkinVariantType(variantType);
        } else {
            log.error("Unknown variant {} for {}", (Object)name, (Object)this);
        }
    }

    default public void handleSkinVariantTypeChange(Enum<?> variant) {
    }

    default public Enum<?> getSkinVariantType(String name) {
        return HumanoidSkinVariant.valueOf(name);
    }

    default public Enum<?>[] getSkinVariantTypes() {
        return HumanoidSkinVariant.values();
    }

    default public Stream<String> getSkinVariantTypeNames() {
        return Stream.of(this.getSkinVariantTypes()).map(Enum::name);
    }

    default public Component getSkinVariantTypeName() {
        Enum<?> variant = this.getSkinVariantType();
        return variant != null ? TextUtils.normalizeName(variant.name()) : this.getEntityTypeName();
    }

    default public boolean hasVariantTypeCrossedArms() {
        return this.hasVariantTypeCrossedArms(this.getSkinVariantType());
    }

    default public boolean hasVariantTypeCrossedArms(Enum<?> variant) {
        return variant != null && variant.name().endsWith("_CROSSED_ARMS");
    }

    default public boolean hasVariantTypeSaddled() {
        return this.hasVariantTypeSaddled(this.getSkinVariantType());
    }

    default public boolean hasVariantTypeSaddled(Enum<?> variant) {
        return variant != null && variant.name().endsWith("_SADDLED");
    }

    default public VillagerProfession getVillagerProfession(Enum<?> variantType) {
        String name = variantType.name().toLowerCase(Locale.ROOT);
        for (VillagerProfession profession : BuiltInRegistries.f_256735_) {
            if (!name.endsWith(profession.f_35600_().toLowerCase(Locale.ROOT))) continue;
            return profession;
        }
        return null;
    }

    default public VillagerType getVillagerType(Enum<?> variantType) {
        String name = variantType.name().toLowerCase(Locale.ROOT);
        for (VillagerType villagerType : BuiltInRegistries.f_256934_) {
            if (!name.startsWith(villagerType.toString().toLowerCase(Locale.ROOT))) continue;
            return villagerType;
        }
        return null;
    }

    default public void defineSynchedVariantData() {
        this.defineSynchedEntityData(SynchedDataIndex.VARIANT_TYPE, this.getDefaultSkinVariantType().name());
    }

    default public void addAdditionalVariantData(CompoundTag compoundTag) {
        if (this.getSkinVariantType() != null) {
            compoundTag.m_128359_(EASY_NPC_DATA_VARIANT_TYPE_TAG, this.getSkinVariantType().name());
        }
    }

    default public void readAdditionalVariantData(CompoundTag compoundTag) {
        String variantType;
        if (compoundTag.m_128441_(EASY_NPC_DATA_VARIANT_TYPE_TAG) && !(variantType = compoundTag.m_128461_(EASY_NPC_DATA_VARIANT_TYPE_TAG)).isEmpty()) {
            this.setSkinVariantType(this.getSkinVariantType(variantType));
        }
    }
}

