/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.handlers;

import de.markusbordihn.easynpc.data.action.ActionDataEntry;
import de.markusbordihn.easynpc.data.action.ActionDataSet;
import de.markusbordihn.easynpc.data.action.ActionDataType;
import de.markusbordihn.easynpc.data.action.ActionEventType;
import de.markusbordihn.easynpc.data.action.ActionGroup;
import de.markusbordihn.easynpc.data.action.ActionManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ActionEventDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.TickerDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.TradingDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.handlers.action.ActionValidator;
import de.markusbordihn.easynpc.entity.easynpc.handlers.action.executor.CommandActionExecutor;
import de.markusbordihn.easynpc.entity.easynpc.handlers.action.executor.DialogActionExecutor;
import de.markusbordihn.easynpc.entity.easynpc.handlers.action.executor.ScoreboardActionExecutor;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public interface ActionHandler<E extends PathfinderMob>
extends EasyNPC<E> {
    default public List<? extends Player> getPlayersInRange(Double range) {
        Entity entity = this.getEntity();
        return this.getEntityLevel().m_6907_().stream().filter(EntitySelector.f_20408_).filter(targetPlayers -> entity.m_19950_((Entity)targetPlayers, range.doubleValue())).toList();
    }

    default public void checkTradingActions() {
        this.getProfiler().m_6180_("npcCheckTradingActions");
        TradingDataCapable tradingData = this.getEasyNPCTradingData();
        TickerDataCapable tickerData = this.getEasyNPCTickerData();
        if (tradingData == null || tickerData == null) {
            return;
        }
        this.getProfiler().m_7238_();
    }

    default public void checkDistanceActions() {
        ServerPlayer serverPlayer;
        ActionDataEntry actionDataEntry;
        List<Player> listOfPlayers;
        this.getProfiler().m_6180_("npcCheckDistanceActions");
        Mob mob = this.getMob();
        ActionEventDataCapable actionEventData = this.getEasyNPCActionEventData();
        if (actionEventData == null || mob == null || mob.m_21224_()) {
            return;
        }
        boolean skipPlayerDistanceCheck = false;
        if (actionEventData.hasActionEvent(ActionEventType.ON_DISTANCE_NEAR)) {
            listOfPlayers = this.getPlayersInRange(16.0);
            if (listOfPlayers == null || listOfPlayers.isEmpty()) {
                ActionManager.removeActionGroup(mob, ActionGroup.DISTANCE_NEAR);
                skipPlayerDistanceCheck = true;
            } else {
                actionDataEntry = actionEventData.getActionEvent(ActionEventType.ON_DISTANCE_NEAR);
                for (Player player : listOfPlayers) {
                    if (!(player instanceof ServerPlayer) || ActionManager.containsPlayer(mob, ActionGroup.DISTANCE_NEAR, serverPlayer = (ServerPlayer)player)) continue;
                    this.executeAction(actionDataEntry, serverPlayer);
                    ActionManager.addPlayer(mob, ActionGroup.DISTANCE_NEAR, serverPlayer);
                }
            }
        }
        if (actionEventData.hasActionEvent(ActionEventType.ON_DISTANCE_CLOSE)) {
            List<Player> list = listOfPlayers = skipPlayerDistanceCheck ? null : this.getPlayersInRange(8.0);
            if (listOfPlayers == null || listOfPlayers.isEmpty()) {
                ActionManager.removeActionGroup(mob, ActionGroup.DISTANCE_CLOSE);
                skipPlayerDistanceCheck = true;
            } else {
                actionDataEntry = actionEventData.getActionEvent(ActionEventType.ON_DISTANCE_CLOSE);
                for (Player player : listOfPlayers) {
                    if (!(player instanceof ServerPlayer) || ActionManager.containsPlayer(mob, ActionGroup.DISTANCE_CLOSE, serverPlayer = (ServerPlayer)player)) continue;
                    this.executeAction(actionDataEntry, serverPlayer);
                    ActionManager.addPlayer(mob, ActionGroup.DISTANCE_CLOSE, serverPlayer);
                }
            }
        }
        if (actionEventData.hasActionEvent(ActionEventType.ON_DISTANCE_VERY_CLOSE)) {
            List<Player> list = listOfPlayers = skipPlayerDistanceCheck ? null : this.getPlayersInRange(4.0);
            if (listOfPlayers == null || listOfPlayers.isEmpty()) {
                ActionManager.removeActionGroup(mob, ActionGroup.DISTANCE_VERY_CLOSE);
                skipPlayerDistanceCheck = true;
            } else {
                actionDataEntry = actionEventData.getActionEvent(ActionEventType.ON_DISTANCE_VERY_CLOSE);
                for (Player player : listOfPlayers) {
                    if (!(player instanceof ServerPlayer) || ActionManager.containsPlayer(mob, ActionGroup.DISTANCE_VERY_CLOSE, serverPlayer = (ServerPlayer)player)) continue;
                    this.executeAction(actionDataEntry, serverPlayer);
                    ActionManager.addPlayer(mob, ActionGroup.DISTANCE_VERY_CLOSE, serverPlayer);
                }
            }
        }
        if (actionEventData.hasActionEvent(ActionEventType.ON_DISTANCE_TOUCH)) {
            List<Player> list = listOfPlayers = skipPlayerDistanceCheck ? null : this.getPlayersInRange(1.25);
            if (listOfPlayers == null || listOfPlayers.isEmpty()) {
                ActionManager.removeActionGroup(mob, ActionGroup.DISTANCE_TOUCH);
            } else {
                actionDataEntry = actionEventData.getActionEvent(ActionEventType.ON_DISTANCE_TOUCH);
                for (Player player : listOfPlayers) {
                    if (!(player instanceof ServerPlayer) || ActionManager.containsPlayer(mob, ActionGroup.DISTANCE_TOUCH, serverPlayer = (ServerPlayer)player)) continue;
                    this.executeAction(actionDataEntry, serverPlayer);
                    ActionManager.addPlayer(mob, ActionGroup.DISTANCE_TOUCH, serverPlayer);
                }
            }
        }
        this.getProfiler().m_7238_();
    }

    default public void interactWithBlock(BlockPos blockPos) {
        LivingEntity livingEntity = this.getLivingEntity();
        if (livingEntity != null && !this.isClientSideInstance()) {
            this.lookAtBlock(blockPos);
            livingEntity.m_6674_(InteractionHand.MAIN_HAND);
            this.getEntityServerLevel().m_8055_(blockPos).m_60664_((Level)this.getEntityServerLevel(), (Player)this.getFakePlayer(this.getEntityServerLevel(), blockPos), InteractionHand.MAIN_HAND, new BlockHitResult(Vec3.m_82512_((Vec3i)blockPos), Direction.DOWN, blockPos, false));
            livingEntity.m_21205_().m_41682_((Level)this.getEntityServerLevel(), (Player)this.getFakePlayer(this.getEntityServerLevel(), blockPos), InteractionHand.MAIN_HAND);
        }
    }

    default public void lookAtBlock(BlockPos target) {
        Entity entity = this.getEntity();
        Vec3 vec3d = entity.m_20182_();
        Vec3 targetVec = Vec3.m_82512_((Vec3i)target);
        Vec3 delta = targetVec.m_82546_(vec3d);
        double horizontalDistance = delta.m_165924_();
        entity.m_146926_(Mth.m_14177_((float)((float)(-(Mth.m_14136_((double)delta.f_82480_, (double)horizontalDistance) * 57.29577951308232)))));
        entity.m_5618_(Mth.m_14177_((float)((float)(Mth.m_14136_((double)delta.f_82481_, (double)delta.f_82479_) * 57.29577951308232) - 90.0f)));
        entity.m_5616_(entity.m_6080_());
    }

    default public void executeActions(ActionDataSet actionDataSet, ServerPlayer serverPlayer) {
        if (actionDataSet == null || actionDataSet.isEmpty()) {
            return;
        }
        ActionDataEntry closeDialogAction = null;
        boolean hasScreenAction = false;
        for (ActionDataEntry actionDataEntry : actionDataSet.getEntries()) {
            ActionDataType actionType = actionDataEntry.actionDataType();
            if (actionType == ActionDataType.CLOSE_DIALOG) {
                if (closeDialogAction == null) {
                    closeDialogAction = actionDataEntry;
                    continue;
                }
                log.warn("Multiple close dialog actions found in action data set {}!", (Object)actionDataSet);
                continue;
            }
            if (actionType == ActionDataType.OPEN_DEFAULT_DIALOG || actionType == ActionDataType.OPEN_NAMED_DIALOG || actionType == ActionDataType.OPEN_TRADING_SCREEN) {
                if (hasScreenAction) {
                    log.debug("Ignoring {}. Multiple screen actions found in action data set {}! Only the first valid will be executed.", (Object)actionType, (Object)actionDataSet);
                    continue;
                }
                if (actionType == ActionDataType.OPEN_DEFAULT_DIALOG && !this.getEasyNPCDialogData().hasDialog() || actionType == ActionDataType.OPEN_NAMED_DIALOG && !this.getEasyNPCDialogData().hasDialog(actionDataEntry.command()) || actionType == ActionDataType.OPEN_TRADING_SCREEN && !this.getEasyNPCTradingData().hasTradingData()) {
                    log.debug("Ignoring {} action because no data is available.", (Object)actionType);
                    continue;
                }
                hasScreenAction = true;
            }
            this.executeAction(actionDataEntry, serverPlayer);
        }
        if (closeDialogAction != null) {
            this.executeAction(closeDialogAction, serverPlayer);
        }
    }

    default public void executeAction(ActionDataEntry actionDataEntry, ServerPlayer serverPlayer) {
        if (!ActionValidator.validateActionData(actionDataEntry, serverPlayer)) {
            return;
        }
        switch (actionDataEntry.actionDataType()) {
            case NONE: {
                break;
            }
            case COMMAND: {
                if (actionDataEntry.executeAsUser()) {
                    CommandActionExecutor.executeAsPlayer(actionDataEntry, serverPlayer, this.getLivingEntity(), this.getEasyNPCActionEventData());
                    break;
                }
                CommandActionExecutor.executeAsEntity(actionDataEntry, serverPlayer, this.getEntity(), this.getLivingEntity(), this.getEasyNPCActionEventData());
                break;
            }
            case CLOSE_DIALOG: {
                serverPlayer.m_6915_();
                break;
            }
            case INTERACT_BLOCK: {
                BlockPos blockPos = actionDataEntry.blockPos();
                if (ActionValidator.validateBlockPos(blockPos)) {
                    this.interactWithBlock(blockPos);
                    break;
                }
                log.error("No block position found for action {}", (Object)actionDataEntry);
                break;
            }
            case OPEN_DEFAULT_DIALOG: {
                DialogActionExecutor.openDefaultDialog(actionDataEntry, serverPlayer, this.getEasyNPCDialogData());
                break;
            }
            case OPEN_NAMED_DIALOG: {
                DialogActionExecutor.openNamedDialog(actionDataEntry, serverPlayer, this.getEasyNPCDialogData());
                break;
            }
            case OPEN_TRADING_SCREEN: {
                TradingDataCapable tradingData = this.getEasyNPCTradingData();
                if (tradingData != null) {
                    tradingData.openTradingScreen(serverPlayer);
                    break;
                }
                log.warn("Cannot execute OPEN_TRADING_SCREEN action for player {}: No trading data found in action {}", (Object)serverPlayer.m_7755_().getString(), (Object)actionDataEntry);
                break;
            }
            case SCOREBOARD: {
                ScoreboardActionExecutor.execute(actionDataEntry, serverPlayer);
                break;
            }
            default: {
                log.warn("Unknown action type {} for action {}", (Object)actionDataEntry.actionDataType(), (Object)actionDataEntry);
            }
        }
    }
}

