/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.handlers.action.executor;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CommandExecutor {
    protected static final Logger log = LogManager.getLogger(CommandExecutor.class);
    private static final Set<String> BLOCKED_UNSAFE_NPC_COMMANDS = new HashSet<String>(List.of("ban-ip", "ban", "banlist", "debug", "deop", "difficulty", "forceload", "gamerule", "kick", "op", "pardon", "reload", "save-all", "save-off", "save-on", "setidletimeout", "setworldspawn", "stop", "whitelist"));

    private CommandExecutor() {
    }

    public static boolean isBlockedUnsafeNPCCommand(String command) {
        String[] runParts;
        String relevant;
        if (command == null || command.isBlank()) {
            return false;
        }
        String cmd = command.trim();
        if (cmd.startsWith("/")) {
            cmd = cmd.substring(1);
        }
        if ((relevant = (runParts = cmd.split("\\s+run\\s+"))[runParts.length - 1].trim()).startsWith("/")) {
            relevant = relevant.substring(1);
        }
        String mainCmd = relevant.split(" ")[0].toLowerCase(Locale.ROOT);
        return BLOCKED_UNSAFE_NPC_COMMANDS.contains(mainCmd);
    }

    public static void executeEntityCommand(String command, Entity entity, int permissionLevel, boolean debug) {
        MinecraftServer minecraftServer = entity.m_20194_();
        if (minecraftServer == null) {
            log.error("No Minecraft server found for entity {}", (Object)entity);
            return;
        }
        if (CommandExecutor.isBlockedUnsafeNPCCommand(command)) {
            log.warn("Blocked unsafe entity command {} for {} with permission level {}!", (Object)command, (Object)entity, (Object)permissionLevel);
            return;
        }
        if (command.startsWith("/")) {
            command = command.substring(1);
        }
        log.debug("Execute Entity {} Command: \"{}\" with permission level {}", (Object)entity, (Object)command, (Object)permissionLevel);
        Commands commands = minecraftServer.m_129892_();
        CommandSourceStack commandSourceStack = minecraftServer.m_129893_().m_81329_(entity).m_81348_(entity.m_20182_()).m_81346_(entity.m_20155_()).m_81325_(permissionLevel);
        CommandDispatcher commandDispatcher = commands.m_82094_();
        ParseResults parseResults = commandDispatcher.parse(command, (Object)(debug ? commandSourceStack : commandSourceStack.m_81324_()));
        commands.m_242674_(parseResults, command);
    }

    public static void executePlayerCommand(String command, ServerPlayer serverPlayer, int permissionLevel, boolean debug) {
        MinecraftServer minecraftServer = serverPlayer.m_20194_();
        if (minecraftServer == null) {
            log.error("No Minecraft server found for player {}", (Object)serverPlayer);
            return;
        }
        if (CommandExecutor.isBlockedUnsafeNPCCommand(command)) {
            log.warn("Blocked unsafe player command {} for {} with permission level {}!", (Object)command, (Object)serverPlayer, (Object)permissionLevel);
            return;
        }
        if (command.startsWith("/")) {
            command = command.substring(1);
        }
        log.debug("Execute Player {} Command: \"{}\" with permission level {}", (Object)serverPlayer, (Object)command, (Object)permissionLevel);
        Commands commands = minecraftServer.m_129892_();
        CommandSourceStack commandSourceStack = minecraftServer.m_129893_().m_81329_((Entity)serverPlayer).m_81348_(serverPlayer.m_20182_()).m_81346_(serverPlayer.m_20155_()).m_81325_(permissionLevel).m_81327_(serverPlayer.m_284548_());
        CommandDispatcher commandDispatcher = commands.m_82094_();
        ParseResults parseResults = commandDispatcher.parse(command, (Object)(debug ? commandSourceStack : commandSourceStack.m_81324_()));
        commands.m_242674_(parseResults, command);
    }
}

