/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.handlers.action.executor;

import de.markusbordihn.easynpc.data.action.ActionDataEntry;
import de.markusbordihn.easynpc.entity.easynpc.data.DialogDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.handlers.action.ActionValidator;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DialogActionExecutor {
    protected static final Logger log = LogManager.getLogger(DialogActionExecutor.class);

    private DialogActionExecutor() {
    }

    public static void openDefaultDialog(ActionDataEntry actionDataEntry, ServerPlayer serverPlayer, DialogDataCapable<?> dialogData) {
        if (!ActionValidator.validateActionData(actionDataEntry, serverPlayer)) {
            return;
        }
        if (dialogData != null) {
            dialogData.openDefaultDialog(serverPlayer);
        } else {
            log.error("No dialog data found for action {}", (Object)actionDataEntry);
            serverPlayer.m_6915_();
        }
    }

    public static void openNamedDialog(ActionDataEntry actionDataEntry, ServerPlayer serverPlayer, DialogDataCapable<?> dialogData) {
        if (!ActionValidator.validateActionData(actionDataEntry, serverPlayer)) {
            return;
        }
        String dialogLabel = actionDataEntry.command();
        if (ActionValidator.validateNamedDialog(dialogData, dialogLabel)) {
            UUID dialogId = dialogData.getDialogId(dialogLabel);
            dialogData.openDialog(serverPlayer, dialogId);
        } else {
            log.error("Unknown dialog label {} for action {}", (Object)dialogLabel, (Object)actionDataEntry);
            serverPlayer.m_6915_();
        }
    }
}

