/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.handler;

import de.markusbordihn.easynpc.data.display.DisplayAttributeType;
import de.markusbordihn.easynpc.data.display.NameVisibilityType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.DisplayAttributeDataCapable;
import de.markusbordihn.easynpc.network.components.TextComponent;
import de.markusbordihn.easynpc.utils.TextUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.entity.Entity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NameHandler {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    private NameHandler() {
    }

    public static boolean setCustomName(EasyNPC<?> easyNPC, String name, int color, boolean visible) {
        return NameHandler.setCustomName(easyNPC, name, color, visible ? NameVisibilityType.ALWAYS : NameVisibilityType.NEVER);
    }

    public static boolean setCustomName(EasyNPC<?> easyNPC, String name, int color, NameVisibilityType nameVisibilityType) {
        if (easyNPC == null || name == null) {
            log.error("[{}] Error setting custom name {}", easyNPC, (Object)name);
            return false;
        }
        Entity entity = easyNPC.getEntity();
        log.debug("[{}] Change custom name to '{}' with color {} and visibility {}", easyNPC, (Object)name, (Object)color, (Object)nameVisibilityType);
        if (name.isEmpty()) {
            log.debug("[{}] Remove custom name", easyNPC);
            entity.m_6593_(null);
            entity.m_20340_(false);
            return true;
        }
        Style style = Style.f_131099_;
        if (color >= 0) {
            style = style.m_131148_(TextColor.m_131266_((int)color));
        }
        entity.m_6593_((Component)TextComponent.getTextComponentRaw(name, TextUtils.isTranslationKey(name)).m_6270_(style));
        entity.m_20340_(nameVisibilityType != NameVisibilityType.NEVER);
        DisplayAttributeDataCapable displayAttributeData = easyNPC.getEasyNPCDisplayAttributeData();
        if (displayAttributeData != null) {
            displayAttributeData.setDisplayAttribute(DisplayAttributeType.NAME_VISIBILITY, nameVisibilityType);
        }
        return true;
    }
}

