/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.menu.dialog;

import de.markusbordihn.easynpc.data.screen.AdditionalScreenData;
import de.markusbordihn.easynpc.data.screen.ScreenData;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.menu.dialog.DialogMenu;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;

public class DialogMenuHandler {
    private DialogMenuHandler() {
    }

    public static MenuProvider getMenuProvider(EasyNPC<?> easyNPC, final MenuType<? extends DialogMenu> menuType, final ScreenData screenData) {
        final Component displayName = easyNPC.getEntity().m_7755_();
        return new MenuProvider(){

            public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
                return new DialogMenu(menuType, containerId, playerInventory, screenData.encode());
            }

            public Component m_5446_() {
                return displayName;
            }

            public String toString() {
                return "DialogMenuHandler{displayName=" + String.valueOf(displayName) + "}";
            }
        };
    }

    public static ScreenData getScreenData(EasyNPC<?> easyNPC, UUID dialogId, int pageIndex, ServerPlayer serverPlayer) {
        UUID npcUUID = easyNPC.getEntityUUID();
        CompoundTag additionalSyncData = new CompoundTag();
        AdditionalScreenData.addActionEventSet(additionalSyncData, easyNPC);
        AdditionalScreenData.addDialogDataSet(additionalSyncData, easyNPC, serverPlayer);
        return new ScreenData(npcUUID, dialogId, null, null, pageIndex, additionalSyncData);
    }
}

