/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.mixin.model;

import de.markusbordihn.easynpc.client.model.EasyNPCModel;
import de.markusbordihn.easynpc.client.model.EasyNPCModelManager;
import de.markusbordihn.easynpc.data.model.ModelPartType;
import de.markusbordihn.easynpc.data.position.CustomPosition;
import de.markusbordihn.easynpc.data.rotation.CustomRotation;
import de.markusbordihn.easynpc.data.scale.CustomScale;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelDataCapable;
import net.minecraft.client.model.CatModel;
import net.minecraft.client.model.OcelotModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.animal.Cat;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CatModel.class})
public class EasyNPCCatModelMixin<T extends Cat>
extends OcelotModel<T> {
    @Unique
    private EasyNPCModelManager easyNPC$modelManager;

    public EasyNPCCatModelMixin(ModelPart modelPart) {
        super(modelPart);
    }

    @Inject(method={"<init>(Lnet/minecraft/client/model/geom/ModelPart;)V"}, at={@At(value="TAIL")})
    private void easyNpcModel(ModelPart modelPart, CallbackInfo callbackInfo) {
        this.easyNPC$modelManager = new EasyNPCModelManager(modelPart).defineModelPart(ModelPartType.HEAD, this.f_103135_).defineModelPart(ModelPartType.BODY, this.f_103136_).defineModelPart(ModelPartType.RIGHT_FRONT_LEG, this.f_170756_).defineModelPart(ModelPartType.LEFT_FRONT_LEG, this.f_170755_).defineModelPart(ModelPartType.RIGHT_HIND_LEG, this.f_170754_).defineModelPart(ModelPartType.LEFT_HIND_LEG, this.f_170753_).defineModelPart(ModelPartType.TAIL1, this.f_103133_).defineModelPart(ModelPartType.TAIL2, this.f_103134_);
    }

    @Inject(method={"setupAnim(Lnet/minecraft/world/entity/animal/Cat;FFFFF)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void setupNpcAnimStart(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo callbackInfo) {
        EasyNPC easyNPC;
        if (entity instanceof EasyNPC && EasyNPCModel.setupAnimationStart(easyNPC = (EasyNPC)entity, this.easyNPC$modelManager)) {
            this.easyNPCAdjustTailToBody(easyNPC);
            callbackInfo.cancel();
        }
    }

    @Unique
    private void easyNPCAdjustTailToBody(EasyNPC<?> easyNPC) {
        ModelDataCapable modelData = easyNPC.getEasyNPCModelData();
        if (modelData == null) {
            return;
        }
        CustomPosition bodyPosition = modelData.getModelPartPosition(ModelPartType.BODY);
        CustomScale bodyScale = modelData.getModelPartScale(ModelPartType.BODY);
        CustomRotation bodyRotation = modelData.getModelPartRotation(ModelPartType.BODY);
        if (bodyScale != null && bodyScale.hasChanged() && Math.abs(bodyScale.x() - 1.0f) + Math.abs(bodyScale.y() - 1.0f) + Math.abs(bodyScale.z() - 1.0f) > 0.5f) {
            this.f_103133_.f_104207_ = false;
            this.f_103134_.f_104207_ = false;
            return;
        }
        if (bodyRotation != null && bodyRotation.hasChanged() && Math.abs(bodyRotation.x()) + Math.abs(bodyRotation.y()) + Math.abs(bodyRotation.z()) > 0.1f) {
            this.f_103133_.f_104207_ = false;
            this.f_103134_.f_104207_ = false;
            return;
        }
        if (bodyPosition == null || !bodyPosition.hasChanged()) {
            return;
        }
        this.f_103133_.f_104207_ = true;
        this.f_103134_.f_104207_ = true;
        this.f_103133_.f_104200_ += bodyPosition.x();
        this.f_103133_.f_104201_ += bodyPosition.y();
        this.f_103133_.f_104202_ += bodyPosition.z();
        this.f_103134_.f_104200_ += bodyPosition.x();
        this.f_103134_.f_104201_ += bodyPosition.y();
        this.f_103134_.f_104202_ += bodyPosition.z();
    }
}

