/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.server.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.markusbordihn.easynpc.access.AccessManager;
import de.markusbordihn.easynpc.commands.Command;
import de.markusbordihn.easynpc.commands.arguments.EasyNPCArgument;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.handler.ReloadHandler;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;

public class ReloadCommand
extends Command {
    private ReloadCommand() {
    }

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"reload").requires(cs -> cs.m_6761_(0))).then(Commands.m_82129_((String)"npc_targets", (ArgumentType)EasyNPCArgument.npc()).executes(context -> ReloadCommand.reload((CommandSourceStack)context.getSource(), EasyNPCArgument.getEntitiesWithAccess((CommandContext<CommandSourceStack>)context, "npc_targets"))));
    }

    private static int reload(CommandSourceStack context, Collection<? extends EasyNPC<?>> easyNPCs) {
        int reloadedEntities = 0;
        for (EasyNPC<?> easyNPC : easyNPCs) {
            UUID uuid = easyNPC.getEntityUUID();
            if (AccessManager.hasAccess(context, uuid)) {
                if (!ReloadHandler.reloadNPC(easyNPC, context.m_81372_())) continue;
                ++reloadedEntities;
                continue;
            }
            ReloadCommand.sendFailureMessage(context, "You are not allowed to reload the Easy NPC " + String.valueOf(uuid) + " !");
        }
        if (reloadedEntities == 1) {
            EasyNPC<?> easyNPC = easyNPCs.iterator().next();
            return ReloadCommand.sendSuccessMessage(context, "Reloaded Easy NPC " + easyNPC.getEntity().m_5446_().getString() + " !");
        }
        if (reloadedEntities > 1) {
            return ReloadCommand.sendSuccessMessage(context, "Reloaded " + reloadedEntities + " of " + easyNPCs.size() + " selected Easy NPCs!");
        }
        return ReloadCommand.sendFailureMessage(context, "Nothing to reload!");
    }
}

