/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.validator;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ImageValidator {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    private ImageValidator() {
    }

    public static boolean isValidImage(URL remoteUrl) {
        BufferedImage image;
        if (remoteUrl.toString().endsWith(".webp")) {
            log.error("WebP images are not supported, please use PNG images!");
        }
        try {
            image = ImageIO.read(remoteUrl);
        }
        catch (IOException | IllegalArgumentException exception) {
            log.error("Unable to get any valid image from URL {}:", (Object)remoteUrl, (Object)exception);
            return false;
        }
        if (image == null) {
            log.error("Unable to get any valid image from URL {}!", (Object)remoteUrl);
            return false;
        }
        return ImageValidator.isValidImage(image);
    }

    public static boolean isValidImage(BufferedImage image) {
        if (image == null) {
            log.error("Found no valid image data in buffer!");
            return false;
        }
        if (image.getWidth() == 48 && image.getHeight() == 32) {
            return true;
        }
        if (image.getWidth() < 32 || image.getHeight() < 32 || image.getWidth() % 32 != 0 || image.getHeight() % 32 != 0) {
            log.error("Unable to get any valid texture from image {}, got {}x{}!", (Object)image, (Object)image.getWidth(), (Object)image.getHeight());
            return false;
        }
        return true;
    }
}

