/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client;

import de.markusbordihn.easynpc.client.ClientEvents;
import de.markusbordihn.easynpc.client.model.ModModelLayer;
import de.markusbordihn.easynpc.client.renderer.BlockEntityRenderer;
import de.markusbordihn.easynpc.client.renderer.EntityRenderer;
import de.markusbordihn.easynpc.client.screen.ClientScreens;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.network.ServerNetworkMessageHandler;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientEventHandler {
    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ClientEvents.handleClientStartedEvent(Minecraft.getInstance());
            NetworkMessageHandlerManager.registerServerHandler(new ServerNetworkMessageHandler());
            ClientScreens.registerScreens(event);
        });
    }

    @SubscribeEvent
    public static void registerEntityLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        ModModelLayer.registerEntityLayerDefinitions(event);
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        EntityRenderer.register(event);
        BlockEntityRenderer.register(event);
    }
}

