/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.markusbordihn.easynpc.block.entity.EasyNPCSpawnerBlockEntity;
import de.markusbordihn.easynpc.level.BaseEasyNPCSpawner;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;

public class BaseEasyNPCSpawnerBlockEntityRenderer<T extends EasyNPCSpawnerBlockEntity>
implements BlockEntityRenderer<T> {
    private final EntityRenderDispatcher entityRenderer;

    public BaseEasyNPCSpawnerBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.entityRenderer = context.getEntityRenderer();
    }

    public void render(T baseEasyNPCSpawnerBlockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, Vec3 cameraPosition) {
        Level level = baseEasyNPCSpawnerBlockEntity.getLevel();
        if (level == null) {
            return;
        }
        BaseEasyNPCSpawner baseSpawner = ((EasyNPCSpawnerBlockEntity)((Object)baseEasyNPCSpawnerBlockEntity)).getSpawner();
        Entity entity = baseSpawner.getOrCreateDisplayEntity(level, baseEasyNPCSpawnerBlockEntity.getBlockPos());
        if (entity == null) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.0f, 0.5f);
        float scale = 0.53125f;
        float maxDimension = Math.max(entity.getBbWidth(), entity.getBbHeight());
        if (maxDimension > 1.0f) {
            scale /= maxDimension;
        }
        poseStack.translate(0.0f, 0.4f, 0.0f);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees((float)Mth.lerp((double)partialTicks, (double)baseSpawner.getoSpin(), (double)baseSpawner.getSpin()) * 10.0f));
        poseStack.translate(0.0f, -0.2f, 0.0f);
        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-30.0f));
        poseStack.scale(scale, scale, scale);
        this.entityRenderer.render(entity, 0.0, 0.0, 0.0, partialTicks, poseStack, bufferSource, packedLight);
        poseStack.popPose();
    }
}

