/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen;

import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.client.screen.components.Graphics;
import de.markusbordihn.easynpc.data.action.ActionEventSet;
import de.markusbordihn.easynpc.data.dialog.DialogButtonEntry;
import de.markusbordihn.easynpc.data.dialog.DialogDataEntry;
import de.markusbordihn.easynpc.data.dialog.DialogDataSet;
import de.markusbordihn.easynpc.data.render.RenderDataSet;
import de.markusbordihn.easynpc.data.screen.AdditionalScreenDataInterface;
import de.markusbordihn.easynpc.data.screen.ScreenData;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.OwnerDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinDataCapable;
import de.markusbordihn.easynpc.menu.ClientMenuManager;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public interface ScreenInterface<D extends AdditionalScreenDataInterface> {
    public EasyNPC<?> getEasyNPC();

    public ScreenData getScreenData();

    public D getAdditionalScreenData();

    default public UUID getEasyNPCUUID() {
        return this.getScreenData().uuid();
    }

    default public Entity getEasyNPCEntity() {
        return this.getEasyNPC() != null ? this.getEasyNPC().getEntity() : null;
    }

    default public LivingEntity getEasyNPCLivingEntity() {
        return this.getEasyNPC() != null ? this.getEasyNPC().getLivingEntity() : null;
    }

    default public OwnerDataCapable<?> getOwnerData() {
        return this.getEasyNPC().getEasyNPCOwnerData();
    }

    default public SkinModel getSkinModel() {
        if (this.getEasyNPCEntity() == null) {
            return null;
        }
        EasyNPC<?> easyNPC = this.getEasyNPC();
        SkinDataCapable skinData = easyNPC.getEasyNPCSkinData();
        return skinData != null ? skinData.getSkinModel() : null;
    }

    default public Component getDialogText() {
        return this.hasDialogData() ? this.getDialogData().getDialogText() : null;
    }

    default public UUID getDialogUUID() {
        return this.getScreenData().dialogId();
    }

    default public UUID getDialogButtonUUID() {
        return this.getScreenData().dialogButtonId();
    }

    default public UUID getActionDataEntryUUID() {
        return this.getScreenData().actionDataEntryId();
    }

    default public UUID getConditionDataEntryUUID() {
        return this.getScreenData().conditionDataEntryId();
    }

    default public int getPageIndex() {
        return this.getScreenData().pageIndex();
    }

    default public ActionEventSet getActionEventSet() {
        return this.getAdditionalScreenData().getActionEventSet();
    }

    default public DialogDataSet getDialogDataSet() {
        return this.getAdditionalScreenData().getDialogDataSet();
    }

    default public RenderDataSet getRenderDataSet() {
        return this.getEasyNPC().getEasyNPCRenderData().getRenderDataSet();
    }

    default public boolean hasDialogData() {
        return this.getDialogData() != null;
    }

    default public DialogDataEntry getDialogData() {
        UUID dialogId = this.getScreenData().dialogId();
        if (dialogId == null) {
            return null;
        }
        return this.getDialogData(dialogId);
    }

    default public DialogDataEntry getDialogData(UUID dialogUUID) {
        return this.getDialogDataSet().getDialog(dialogUUID);
    }

    default public DialogButtonEntry getDialogButtonData() {
        if (!this.hasDialog() || this.getScreenData().dialogButtonId() == null) {
            return null;
        }
        DialogDataEntry dialogData = this.getDialogData();
        if (dialogData == null) {
            return null;
        }
        return dialogData.getDialogButton(this.getScreenData().dialogButtonId());
    }

    default public boolean hasDialog() {
        return this.getDialogDataSet().hasDialog();
    }

    default public boolean isSwitchingToAnotherEasyNPCScreen(Screen newScreen) {
        if (newScreen == this || newScreen == null) {
            ScreenData pendingScreenData = ClientMenuManager.getScreenData();
            return pendingScreenData != null && this.getEasyNPCUUID().equals(pendingScreenData.uuid());
        }
        if (newScreen instanceof ScreenInterface) {
            ScreenInterface screenInterface = (ScreenInterface)newScreen;
            if (this.getEasyNPCUUID().equals(screenInterface.getEasyNPCUUID())) {
                return true;
            }
        }
        return false;
    }

    default public void renderDefaultScreenBg(GuiGraphics guiGraphics, int leftPos, int topPos) {
        Graphics.blit(guiGraphics, Constants.TEXTURE_DEMO_BACKGROUND, leftPos, topPos, 0, 0, 220, 160);
        Graphics.blit(guiGraphics, Constants.TEXTURE_DEMO_BACKGROUND, leftPos + 213, topPos, 132, 0, 120, 160);
        Graphics.blit(guiGraphics, Constants.TEXTURE_DEMO_BACKGROUND, leftPos, topPos + 77, 0, 5, 220, 170);
        Graphics.blit(guiGraphics, Constants.TEXTURE_DEMO_BACKGROUND, leftPos + 213, topPos + 77, 132, 5, 120, 170);
    }

    default public void renderDefaultTitleBg(GuiGraphics guiGraphics, int leftPos, int topPos) {
        Graphics.blit(guiGraphics, Constants.TEXTURE_DEMO_BACKGROUND, leftPos, topPos - 16, 0, 0, 248, 19);
    }
}

