/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.components;

import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.network.components.TextComponent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class Checkbox
extends AbstractButton {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"easy_npc", (String)"textures/gui/checkbox.png");
    protected final OnChange onChange;
    private final boolean showLabel;
    private final Font font;
    private boolean selected;

    public Checkbox(int left, int top, String label, boolean selected, OnChange onChange) {
        this(left, top, (Component)TextComponent.getTextComponent(label), selected, true, onChange);
    }

    public Checkbox(int left, int top, String label, Component data, boolean selected, OnChange onChange) {
        this(left, top, (Component)TextComponent.getTextComponent(label, data), selected, true, onChange);
    }

    public Checkbox(int left, int top, String label, String data, boolean selected, OnChange onChange) {
        this(left, top, (Component)TextComponent.getTextComponent(label, data), selected, true, onChange);
    }

    public Checkbox(int left, int top, String label, boolean selected) {
        this(left, top, (Component)TextComponent.getTranslatedText(label), selected, true);
    }

    public Checkbox(int left, int top, Component component, boolean selected, boolean showLabel) {
        this(left, top, component, selected, showLabel, null);
    }

    public Checkbox(int left, int top, Component component, boolean selected, boolean showLabel, OnChange onChange) {
        super(left, top, 16, 16, component);
        this.selected = selected;
        this.showLabel = showLabel;
        Minecraft minecraft = Minecraft.getInstance();
        this.font = minecraft.font;
        this.onChange = onChange;
    }

    public void onPress() {
        boolean bl = this.selected = !this.selected;
        if (this.onChange != null) {
            this.onChange.onChange(this);
        }
    }

    public boolean selected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.add(NarratedElementType.TITLE, (Component)this.createNarrationMessage());
        if (this.active) {
            if (this.isFocused()) {
                narrationElementOutput.add(NarratedElementType.USAGE, (Component)TextComponent.getTranslatedTextRaw("narration.checkbox.usage.focused"));
            } else {
                narrationElementOutput.add(NarratedElementType.USAGE, (Component)TextComponent.getTranslatedTextRaw("narration.checkbox.usage.hovered"));
            }
        }
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderButton(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public void renderButton(GuiGraphics guiGraphics, int left, int top, float partialTicks) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, this.getX(), this.getY(), this.active ? (float)(this.isHoveredOrFocused() ? 16 : 0) : 32.0f, this.selected ? 16.0f : 0.0f, 16, 16, 64, 64);
        if (this.showLabel) {
            Text.drawString(guiGraphics, this.font, this.getMessage(), this.getX() + 18, this.getY() + (this.height - 8) / 2);
        }
    }

    public static interface OnChange {
        public void onChange(Checkbox var1);
    }
}

