/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.components;

import de.markusbordihn.easynpc.network.components.TextComponent;
import net.minecraft.client.InputType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SliderButton
extends AbstractSliderButton {
    public static final int DEFAULT_HEIGHT = 16;
    protected static final Component EMPTY_TEXT = TextComponent.getBlankText();
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private static final ResourceLocation SLIDER_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"widget/slider");
    private static final ResourceLocation HIGHLIGHTED_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"widget/slider_highlighted");
    private static final ResourceLocation SLIDER_HANDLE_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"widget/slider_handle");
    private static final ResourceLocation SLIDER_HANDLE_HIGHLIGHTED_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"widget/slider_handle_highlighted");
    protected final OnChange onChange;
    protected final float maxValue;
    private final float minValue;
    private final float stepSize;
    private final float valueFraction;
    private final Type type;
    private boolean canChangeValue;
    private float initValue;
    private float roundFactor = 100.0f;
    private float targetValue;
    private float formerTargetValue;

    public SliderButton(int x, int y, int width, String name, float initValue, Type type, OnChange onChange) {
        this(x, y, width, 16, (Component)TextComponent.getText(name), initValue, SliderButton.getMinValue(type), SliderButton.getMaxValue(type), onChange, type);
    }

    public SliderButton(int x, int y, int width, int height, float initValue, Type type, OnChange onChange) {
        this(x, y, width, height, EMPTY_TEXT, initValue, SliderButton.getMinValue(type), SliderButton.getMaxValue(type), onChange, type);
    }

    public SliderButton(int x, int y, int width, int height, String name, double initValue, double minValue, double maxValue, OnChange onChange) {
        this(x, y, width, height, (Component)TextComponent.getText(name), (float)initValue, (float)minValue, (float)maxValue, onChange, Type.DOUBLE);
    }

    public SliderButton(int x, int y, int width, int height, double initValue, double minValue, double maxValue, OnChange onChange, Type type) {
        this(x, y, width, height, EMPTY_TEXT, (float)initValue, (float)minValue, (float)maxValue, onChange, type);
    }

    public SliderButton(int x, int y, int width, int height, Component name, float initValue, float minValue, float maxValue, OnChange onChange, Type type) {
        super(x, y, width, height, name, (double)initValue);
        this.initValue = initValue;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.stepSize = SliderButton.getStepSize(type);
        this.valueFraction = maxValue - minValue;
        this.value = (this.initValue - minValue) / this.valueFraction;
        if (this.minValue == 0.0f && this.maxValue == 360.0f || this.minValue == -180.0f && this.maxValue == 180.0f) {
            this.roundFactor = 1.0f;
        }
        this.onChange = onChange;
        this.type = type;
        this.updateTargetValue();
        this.updateMessage();
    }

    static float getMinValue(Type type) {
        return switch (type.ordinal()) {
            case 1 -> -180.0f;
            case 0 -> 0.0f;
            case 3 -> 0.1f;
            case 2 -> -24.0f;
            default -> -100.0f;
        };
    }

    static float getMaxValue(Type type) {
        return switch (type.ordinal()) {
            case 1 -> 180.0f;
            case 0 -> 1024.0f;
            case 3 -> 10.0f;
            case 2 -> 24.0f;
            default -> 100.0f;
        };
    }

    static float getStepSize(Type type) {
        return switch (type.ordinal()) {
            case 1 -> 0.5f;
            case 0 -> 1.0f;
            case 2, 3 -> 0.1f;
            default -> 1.0f;
        };
    }

    public void setDefaultValue(double value) {
        this.setDefaultValue((float)Math.round(value * (double)this.roundFactor) / this.roundFactor);
    }

    public void setDefaultValue(float value) {
        this.initValue = value;
        this.value = (this.initValue - this.minValue) / this.valueFraction;
        this.applyValue();
        this.updateMessage();
    }

    public void reset() {
        switch (this.type.ordinal()) {
            case 0: 
            case 1: 
            case 2: {
                this.setDefaultValue(0.0f);
                break;
            }
            case 3: {
                this.setDefaultValue(1.0f);
                break;
            }
            default: {
                log.warn("Unknown slider type {}. Falling back to 0 as default value.", (Object)this.type);
                this.setDefaultValue(0.0f);
            }
        }
    }

    public float getTargetValue() {
        return this.targetValue;
    }

    private void setTargetValue(double value) {
        this.value = value < 0.0 ? 0.0 : (value > 1.0 ? 1.0 : value);
        this.applyValue();
        this.updateMessage();
    }

    public double getTargetDoubleValue() {
        return this.targetValue;
    }

    private void updateTargetValue() {
        this.targetValue = (float)Math.round(((double)this.minValue + (double)this.valueFraction * this.value) * (double)this.roundFactor) / this.roundFactor;
    }

    private double getStepSize() {
        return this.stepSize / this.valueFraction;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void triggerOnDrag(double mouseX, double mouseY, double deltaX, double deltaY) {
        this.onDrag(mouseX, mouseY, deltaX, deltaY);
    }

    protected void updateMessage() {
        switch (this.type.ordinal()) {
            case 1: {
                this.setMessage((Component)TextComponent.getText(this.targetValue + "\u00b0"));
                break;
            }
            default: {
                this.setMessage((Component)TextComponent.getText("" + this.targetValue));
            }
        }
    }

    protected void applyValue() {
        this.updateTargetValue();
        if (this.targetValue != this.formerTargetValue) {
            this.onChange.onChange(this);
            this.formerTargetValue = this.targetValue;
        }
    }

    public boolean keyPressed(int keyCode, int unused1, int unused2) {
        if (keyCode == 263 || keyCode == 262) {
            float step = keyCode == 263 ? -1.0f : 1.0f;
            double incrementalSteps = (double)step * this.getStepSize();
            this.setTargetValue(this.value + incrementalSteps);
        }
        return false;
    }

    public boolean mouseScrolled(double x, double y, double scrollDeltaX, double scrollDeltaY) {
        if (this.isHoveredOrFocused()) {
            double incrementalSteps = scrollDeltaY * this.getStepSize();
            this.setTargetValue(this.value + incrementalSteps);
            return true;
        }
        return false;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderButton(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public void renderButton(GuiGraphics guiGraphics, int left, int top, float partialTicks) {
        Minecraft minecraft = Minecraft.getInstance();
        Font font = minecraft.font;
        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, this.getSliderSprite(), this.getX(), this.getY(), this.getWidth(), this.getHeight());
        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, this.getSliderHandleSprite(), this.getX() + (int)(this.value * (double)(this.width - 8)), this.getY(), 8, this.getHeight());
        int fgColor = this.active ? -1 : -6250336;
        guiGraphics.drawCenteredString(font, this.getMessage(), this.getX() + this.width / 2, this.getY() + (this.height - 8) / 2, fgColor | Mth.ceil((float)(this.alpha * 255.0f)) << 24);
    }

    private ResourceLocation getSliderSprite() {
        return this.isFocused() && !this.canChangeValue ? HIGHLIGHTED_SPRITE : SLIDER_SPRITE;
    }

    private ResourceLocation getSliderHandleSprite() {
        return !this.isHovered && !this.canChangeValue ? SLIDER_HANDLE_SPRITE : SLIDER_HANDLE_HIGHLIGHTED_SPRITE;
    }

    public void setFocused(boolean focus) {
        super.setFocused(focus);
        if (!focus) {
            this.canChangeValue = false;
        } else {
            InputType inputType = Minecraft.getInstance().getLastInputType();
            if (inputType == InputType.MOUSE || inputType == InputType.KEYBOARD_TAB) {
                this.canChangeValue = true;
            }
        }
    }

    public static enum Type {
        DOUBLE,
        DEGREE,
        POSITION,
        SCALE,
        UNKNOWN;

    }

    public static interface OnChange {
        public void onChange(SliderButton var1);
    }
}

