/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.condition;

public enum ConditionType {
    NONE(false, false, false),
    SCOREBOARD(true, true, true),
    EXECUTION_LIMIT(false, true, false);

    private final boolean requiresName;
    private final boolean requiresValue;
    private final boolean requiresOperation;

    private ConditionType(boolean requiresName, boolean requiresValue, boolean requiresOperation) {
        this.requiresName = requiresName;
        this.requiresValue = requiresValue;
        this.requiresOperation = requiresOperation;
    }

    public static ConditionType get(String conditionType) {
        if (conditionType == null || conditionType.isEmpty()) {
            return NONE;
        }
        try {
            return ConditionType.valueOf(conditionType);
        }
        catch (IllegalArgumentException e) {
            return NONE;
        }
    }

    public boolean requiresName() {
        return this.requiresName;
    }

    public boolean requiresValue() {
        return this.requiresValue;
    }

    public boolean requiresOperation() {
        return this.requiresOperation;
    }
}

