/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.condition;

import de.markusbordihn.easynpc.data.condition.ConditionDataEntry;
import de.markusbordihn.easynpc.data.condition.ConditionType;
import de.markusbordihn.easynpc.data.execution.ExecutionInterval;
import de.markusbordihn.easynpc.data.saveddata.ActionExecutionTracker;
import java.util.Set;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Scoreboard;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConditionUtils {
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    private ConditionUtils() {
    }

    public static boolean evaluateCondition(ConditionDataEntry conditionDataEntry, ServerPlayer player) {
        return ConditionUtils.evaluateCondition(conditionDataEntry, player, null);
    }

    public static boolean evaluateCondition(ConditionDataEntry conditionDataEntry, ServerPlayer player, UUID actionUUID) {
        if (conditionDataEntry == null || !conditionDataEntry.isValid() || player == null) {
            return false;
        }
        return switch (conditionDataEntry.conditionType()) {
            default -> throw new MatchException(null, null);
            case ConditionType.SCOREBOARD -> ConditionUtils.evaluateScoreboardCondition(conditionDataEntry, player);
            case ConditionType.EXECUTION_LIMIT -> ConditionUtils.evaluateExecutionLimit(conditionDataEntry, player, actionUUID);
            case ConditionType.NONE -> true;
        };
    }

    public static boolean evaluateConditions(Set<ConditionDataEntry> conditions, ServerPlayer player) {
        return ConditionUtils.evaluateConditions(conditions, player, null);
    }

    public static boolean evaluateConditions(Set<ConditionDataEntry> conditions, ServerPlayer player, UUID actionUUID) {
        if (conditions == null || conditions.isEmpty() || player == null) {
            return true;
        }
        for (ConditionDataEntry condition : conditions) {
            if (ConditionUtils.evaluateCondition(condition, player, actionUUID)) continue;
            log.debug("Condition not met: {}", (Object)condition);
            return false;
        }
        return true;
    }

    public static boolean evaluateExecutionLimit(ConditionDataEntry conditionDataEntry, ServerPlayer player, UUID actionUUID) {
        if (player == null || actionUUID == null) {
            return false;
        }
        int limit = conditionDataEntry.value();
        ExecutionInterval interval = ExecutionInterval.get(conditionDataEntry.text());
        ActionExecutionTracker tracker = ActionExecutionTracker.get(player.level());
        boolean canExecute = tracker.canExecute(player.getUUID(), actionUUID, limit, interval);
        log.debug("Execution limit check for player {} action {}: limit={}, interval={}, canExecute={}", (Object)player.getGameProfile().getName(), (Object)actionUUID, (Object)limit, (Object)interval, (Object)canExecute);
        return canExecute;
    }

    public static void recordActionExecution(ConditionDataEntry conditionDataEntry, ServerPlayer player, UUID actionUUID) {
        if (conditionDataEntry == null || conditionDataEntry.conditionType() != ConditionType.EXECUTION_LIMIT || player == null || actionUUID == null) {
            return;
        }
        ExecutionInterval interval = ExecutionInterval.get(conditionDataEntry.text());
        ActionExecutionTracker tracker = ActionExecutionTracker.get(player.level());
        tracker.recordExecution(player.getUUID(), actionUUID, interval);
    }

    public static boolean evaluateScoreboardCondition(ConditionDataEntry conditionDataEntry, ServerPlayer serverPlayer) {
        if (!conditionDataEntry.hasName() || serverPlayer == null) {
            return false;
        }
        try {
            Scoreboard scoreboard = serverPlayer.getScoreboard();
            Objective objective = scoreboard.getObjective(conditionDataEntry.name());
            if (objective == null) {
                log.debug("Scoreboard objective '{}' not found for player {}", (Object)conditionDataEntry.name(), (Object)serverPlayer.getName().getString());
                return false;
            }
            ScoreAccess scoreAccess = scoreboard.getOrCreatePlayerScore((ScoreHolder)serverPlayer, objective);
            int scoreValue = scoreAccess.get();
            int targetValue = conditionDataEntry.value();
            boolean result = conditionDataEntry.operationType().evaluate(scoreValue, targetValue);
            log.debug("Scoreboard evaluation: {} {} {} = {} (actual: {})", (Object)conditionDataEntry.name(), (Object)conditionDataEntry.operationType().getSymbol(), (Object)targetValue, (Object)result, (Object)scoreValue);
            return result;
        }
        catch (Exception e) {
            log.error("Error evaluating scoreboard condition: {}", (Object)conditionDataEntry, (Object)e);
            return false;
        }
    }
}

