/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.dialog;

import de.markusbordihn.easynpc.data.condition.ConditionDataEntry;
import de.markusbordihn.easynpc.data.dialog.DialogButtonEntry;
import de.markusbordihn.easynpc.data.dialog.DialogMetaData;
import de.markusbordihn.easynpc.data.dialog.DialogPriority;
import de.markusbordihn.easynpc.data.dialog.DialogTextData;
import de.markusbordihn.easynpc.data.dialog.DialogUtils;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;

public final class DialogDataEntry {
    public static final String DATA_BUTTONS_TAG = "Buttons";
    public static final String DATA_CONDITIONS_TAG = "Conditions";
    public static final String DATA_DIALOG_NAME = "Name";
    public static final String DATA_LABEL_TAG = "Label";
    public static final String DATA_PRIORITY_TAG = "Priority";
    public static final String DATA_TEXTS_TAG = "Texts";
    public static final String DATA_TEXT_TAG = "Text";
    public static final int MAX_DIALOG_LABEL_LENGTH = 32;
    private Set<DialogButtonEntry> dialogButtons = new LinkedHashSet<DialogButtonEntry>();
    private Set<DialogTextData> dialogTexts = new LinkedHashSet<DialogTextData>();
    private Set<ConditionDataEntry> conditions = new LinkedHashSet<ConditionDataEntry>();
    private UUID id;
    private String label = "";
    private String name;
    private int priority;

    public DialogDataEntry(CompoundTag compoundTag) {
        this.load(compoundTag);
    }

    public DialogDataEntry(String name) {
        this(null, name, "Dialog text", null);
    }

    public DialogDataEntry(String name, String text) {
        this("default", name, text, null);
    }

    public DialogDataEntry(String label, String name, String text) {
        this(label, name, text, null);
    }

    public DialogDataEntry(String label, String name, String text, Set<DialogButtonEntry> dialogButtons) {
        this.label = DialogUtils.generateButtonLabel(label != null && !label.isEmpty() ? label : name);
        this.id = UUID.nameUUIDFromBytes(this.label.getBytes());
        this.name = name != null ? name.trim() : this.label;
        this.dialogButtons = dialogButtons != null ? dialogButtons : new LinkedHashSet();
        this.dialogTexts.add(new DialogTextData(text));
        this.priority = DialogPriority.calculateDefaultPriority(this.label);
    }

    public UUID getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = DialogUtils.generateButtonLabel(label != null && !label.isEmpty() ? label : this.name);
        this.id = UUID.nameUUIDFromBytes(this.label.getBytes());
    }

    public String getLabel(int maxLength) {
        return this.label.length() > maxLength ? this.label.substring(0, maxLength - 1) + "\u2026" : this.label;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name != null ? name.trim() : "";
    }

    public String getName(int maxLength) {
        return this.name.length() > maxLength ? this.name.substring(0, maxLength - 1) + "\u2026" : this.name;
    }

    public String getText() {
        return this.dialogTexts.iterator().next().text();
    }

    public Component getDialogText() {
        if (this.dialogTexts == null || this.dialogTexts.isEmpty()) {
            return Component.empty();
        }
        DialogTextData dialogTextData = this.dialogTexts.size() == 1 ? this.dialogTexts.iterator().next() : (DialogTextData)this.dialogTexts.stream().skip(ThreadLocalRandom.current().nextInt(this.dialogTexts.size())).findFirst().orElse(null);
        return dialogTextData != null ? dialogTextData.getDialogText() : Component.empty();
    }

    public String getText(int maxLength) {
        return this.dialogTexts.iterator().next().getText(maxLength);
    }

    public String getDialogText(DialogMetaData dialogMetaData) {
        return DialogUtils.parseDialogText(this.getDialogText(), dialogMetaData);
    }

    public Set<DialogTextData> getDialogTexts() {
        return this.dialogTexts;
    }

    public void setDialogTexts(Set<DialogTextData> dialogTexts) {
        this.dialogTexts = dialogTexts != null ? dialogTexts : new LinkedHashSet();
    }

    public Set<DialogButtonEntry> getDialogButtons() {
        return this.dialogButtons;
    }

    public void setDialogButtons(Set<DialogButtonEntry> buttons) {
        this.dialogButtons = buttons != null ? buttons : new LinkedHashSet();
    }

    public Set<ConditionDataEntry> getConditions() {
        return this.conditions;
    }

    public void setConditions(Set<ConditionDataEntry> conditions) {
        this.conditions = conditions != null ? conditions : new LinkedHashSet();
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority < -1 ? -1 : priority;
    }

    public DialogButtonEntry getDialogButton(UUID dialogButtonId) {
        for (DialogButtonEntry button : this.dialogButtons) {
            if (!button.id().equals(dialogButtonId)) continue;
            return button;
        }
        return null;
    }

    public DialogButtonEntry getDialogButton(String label) {
        for (DialogButtonEntry button : this.dialogButtons) {
            if (!button.label().equals(label)) continue;
            return button;
        }
        return null;
    }

    public void setDialogButton(DialogButtonEntry dialogButtonEntry) {
        this.setDialogButton(dialogButtonEntry.id(), dialogButtonEntry);
    }

    public void setDialogButton(UUID dialogButtonId, DialogButtonEntry dialogButtonEntry) {
        if (dialogButtonId != null) {
            for (DialogButtonEntry button : this.dialogButtons) {
                if (!button.id().equals(dialogButtonId)) continue;
                this.dialogButtons.remove(button);
                this.dialogButtons.add(dialogButtonEntry);
                return;
            }
        }
        this.dialogButtons.add(dialogButtonEntry);
    }

    public boolean hasDialogButton(String label) {
        for (DialogButtonEntry button : this.dialogButtons) {
            if (!button.label().equals(label)) continue;
            return true;
        }
        return false;
    }

    public boolean hasDialogButton(UUID dialogButtonId) {
        for (DialogButtonEntry button : this.dialogButtons) {
            if (!button.id().equals(dialogButtonId)) continue;
            return true;
        }
        return false;
    }

    public boolean removeDialogButton(UUID dialogButtonId) {
        for (DialogButtonEntry button : this.dialogButtons) {
            if (!button.id().equals(dialogButtonId)) continue;
            this.dialogButtons.remove(button);
            return true;
        }
        return false;
    }

    public int getNumberOfDialogButtons() {
        return this.dialogButtons.size();
    }

    public void load(CompoundTag compoundTag) {
        int i;
        this.name = compoundTag.getString(DATA_DIALOG_NAME).orElse("");
        this.setLabel(compoundTag.contains(DATA_LABEL_TAG) ? compoundTag.getString(DATA_LABEL_TAG).orElse("") : this.name);
        if (compoundTag.contains(DATA_TEXTS_TAG)) {
            this.dialogTexts.clear();
            ListTag dialogTextsList = compoundTag.getListOrEmpty(DATA_TEXTS_TAG);
            if (!dialogTextsList.isEmpty()) {
                for (i = 0; i < dialogTextsList.size(); ++i) {
                    this.dialogTexts.add(new DialogTextData(dialogTextsList.getCompoundOrEmpty(i)));
                }
            }
        } else if (compoundTag.contains(DATA_TEXT_TAG)) {
            this.dialogTexts.clear();
            this.dialogTexts.add(new DialogTextData(compoundTag.getString(DATA_TEXT_TAG).orElse("")));
        }
        if (compoundTag.contains(DATA_BUTTONS_TAG)) {
            this.dialogButtons.clear();
            ListTag buttonsList = compoundTag.getListOrEmpty(DATA_BUTTONS_TAG);
            if (!buttonsList.isEmpty()) {
                for (i = 0; i < buttonsList.size(); ++i) {
                    this.dialogButtons.add(new DialogButtonEntry(buttonsList.getCompoundOrEmpty(i)));
                }
            }
        }
        if (compoundTag.contains(DATA_CONDITIONS_TAG)) {
            this.conditions.clear();
            ListTag conditionsList = compoundTag.getListOrEmpty(DATA_CONDITIONS_TAG);
            if (!conditionsList.isEmpty()) {
                for (i = 0; i < conditionsList.size(); ++i) {
                    ConditionDataEntry conditionEntry = new ConditionDataEntry(conditionsList.getCompoundOrEmpty(i));
                    if (!conditionEntry.isValid()) continue;
                    this.conditions.add(conditionEntry);
                }
            }
        }
        this.priority = compoundTag.getInt(DATA_PRIORITY_TAG).orElse(DialogPriority.calculateDefaultPriority(this.label));
    }

    public CompoundTag save(CompoundTag compoundTag) {
        int defaultPriority;
        compoundTag.putString(DATA_DIALOG_NAME, this.name.trim());
        if (!Objects.equals(DialogUtils.generateDialogLabel(this.name), this.label)) {
            compoundTag.putString(DATA_LABEL_TAG, this.label);
        }
        if (this.dialogTexts != null && !this.dialogTexts.isEmpty()) {
            ListTag dialogTextsList = new ListTag();
            for (DialogTextData dialogText : this.dialogTexts) {
                dialogTextsList.add((Object)dialogText.write(new CompoundTag()));
            }
            compoundTag.put(DATA_TEXTS_TAG, (Tag)dialogTextsList);
        }
        if (this.dialogButtons != null && !this.dialogButtons.isEmpty()) {
            ListTag buttonsList = new ListTag();
            for (DialogButtonEntry button : this.dialogButtons) {
                buttonsList.add((Object)button.write(new CompoundTag()));
            }
            compoundTag.put(DATA_BUTTONS_TAG, (Tag)buttonsList);
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            ListTag conditionsList = new ListTag();
            for (ConditionDataEntry condition : this.conditions) {
                if (!condition.isValid()) continue;
                conditionsList.add((Object)condition.createTag());
            }
            if (!conditionsList.isEmpty()) {
                compoundTag.put(DATA_CONDITIONS_TAG, (Tag)conditionsList);
            }
        }
        if (this.priority != (defaultPriority = DialogPriority.calculateDefaultPriority(this.label))) {
            compoundTag.putInt(DATA_PRIORITY_TAG, this.priority);
        }
        return compoundTag;
    }

    public CompoundTag createTag() {
        return this.save(new CompoundTag());
    }

    public String toString() {
        return "DialogData [id=" + String.valueOf(this.id) + ", name=" + this.name + ", label=" + this.label + ", texts=" + String.valueOf(this.dialogTexts) + ", buttons=" + String.valueOf(this.dialogButtons) + ", conditions=" + String.valueOf(this.conditions) + "]";
    }
}

