/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.saveddata;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import de.markusbordihn.easynpc.data.execution.ExecutionData;
import de.markusbordihn.easynpc.data.execution.ExecutionInterval;
import de.markusbordihn.easynpc.utils.CompoundTagUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ActionExecutionTracker
extends SavedData {
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private static final String DATA_NAME = "easy_npc_action_executions";
    private static final String DATA_PLAYERS_TAG = "Players";
    private static final String DATA_PLAYER_UUID_TAG = "PlayerUUID";
    private static final String DATA_ACTIONS_TAG = "Actions";
    private static final String DATA_ACTION_UUID_TAG = "ActionUUID";
    public static final SavedDataType<ActionExecutionTracker> TYPE = new SavedDataType("easy_npc_action_executions", ActionExecutionTracker::new, context -> ActionExecutionTracker.codec(), DataFixTypes.SAVED_DATA_STRUCTURE_FEATURE_INDICES);
    private final Map<UUID, Map<UUID, ExecutionData>> trackingData;

    private static Codec<ActionExecutionTracker> codec() {
        return Codec.PASSTHROUGH.comapFlatMap(dynamic -> {
            try {
                return DataResult.success((Object)((Object)ActionExecutionTracker.loadFromNbt(dynamic)));
            }
            catch (Exception e) {
                return DataResult.error(() -> "Failed to load ActionExecutionTracker: " + e.getMessage());
            }
        }, tracker -> new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)ActionExecutionTracker.saveToNbt(tracker)));
    }

    private static ActionExecutionTracker loadFromNbt(Dynamic<?> dynamic) {
        ActionExecutionTracker tracker = new ActionExecutionTracker(new HashMap<UUID, Map<UUID, ExecutionData>>());
        Tag tag = (Tag)dynamic.convert((DynamicOps)NbtOps.INSTANCE).getValue();
        if (!(tag instanceof CompoundTag)) {
            return tracker;
        }
        CompoundTag compoundTag = (CompoundTag)tag;
        ListTag playersTag = compoundTag.getListOrEmpty(DATA_PLAYERS_TAG);
        for (int i = 0; i < playersTag.size(); ++i) {
            CompoundTag playerTag = playersTag.getCompoundOrEmpty(i);
            UUID playerUUID = CompoundTagUtils.readUUID(playerTag, DATA_PLAYER_UUID_TAG);
            if (playerUUID == null) continue;
            HashMap<UUID, ExecutionData> playerData = new HashMap<UUID, ExecutionData>();
            ListTag actionsTag = playerTag.getListOrEmpty(DATA_ACTIONS_TAG);
            for (int j = 0; j < actionsTag.size(); ++j) {
                CompoundTag actionTag = actionsTag.getCompoundOrEmpty(j);
                UUID actionUUID = CompoundTagUtils.readUUID(actionTag, DATA_ACTION_UUID_TAG);
                if (actionUUID == null) continue;
                playerData.put(actionUUID, new ExecutionData(actionTag));
            }
            tracker.trackingData.put(playerUUID, playerData);
        }
        return tracker;
    }

    private static CompoundTag saveToNbt(ActionExecutionTracker tracker) {
        CompoundTag compoundTag = new CompoundTag();
        ListTag playersTag = new ListTag();
        for (Map.Entry<UUID, Map<UUID, ExecutionData>> playerEntry : tracker.trackingData.entrySet()) {
            CompoundTag playerTag = new CompoundTag();
            CompoundTagUtils.writeUUID(playerTag, DATA_PLAYER_UUID_TAG, playerEntry.getKey());
            ListTag actionsTag = new ListTag();
            for (Map.Entry<UUID, ExecutionData> actionEntry : playerEntry.getValue().entrySet()) {
                CompoundTag actionTag = new CompoundTag();
                CompoundTagUtils.writeUUID(actionTag, DATA_ACTION_UUID_TAG, actionEntry.getKey());
                actionEntry.getValue().save(actionTag);
                actionsTag.add((Object)actionTag);
            }
            playerTag.put(DATA_ACTIONS_TAG, (Tag)actionsTag);
            playersTag.add((Object)playerTag);
        }
        compoundTag.put(DATA_PLAYERS_TAG, (Tag)playersTag);
        return compoundTag;
    }

    private ActionExecutionTracker(SavedData.Context context) {
        this(new HashMap<UUID, Map<UUID, ExecutionData>>());
    }

    private ActionExecutionTracker(Map<UUID, Map<UUID, ExecutionData>> trackingData) {
        this.trackingData = new HashMap<UUID, Map<UUID, ExecutionData>>(trackingData);
    }

    public static ActionExecutionTracker get(ServerLevel serverLevel) {
        return (ActionExecutionTracker)serverLevel.getDataStorage().computeIfAbsent(TYPE);
    }

    public boolean canExecute(UUID playerUUID, UUID actionUUID, int limit, ExecutionInterval interval) {
        if (limit == 0) {
            return true;
        }
        ExecutionData data = (ExecutionData)((Map)this.trackingData.getOrDefault(playerUUID, new HashMap())).get(actionUUID);
        if (data == null) {
            return true;
        }
        if (interval == ExecutionInterval.LIFETIME) {
            return data.executionCount() < limit;
        }
        if (interval.hasIntervalPassed(data.windowStartTime())) {
            return true;
        }
        return data.executionCount() < limit;
    }

    public void recordExecution(UUID playerUUID, UUID actionUUID, ExecutionInterval interval) {
        Map playerData = this.trackingData.computeIfAbsent(playerUUID, k -> new HashMap());
        ExecutionData currentData = (ExecutionData)playerData.get(actionUUID);
        long now = System.currentTimeMillis();
        if (currentData == null || interval.hasIntervalPassed(currentData.windowStartTime())) {
            playerData.put(actionUUID, new ExecutionData(1, now, now));
            log.debug("Started new execution window for player {} action {} with interval {}", (Object)playerUUID, (Object)actionUUID, (Object)interval);
        } else {
            playerData.put(actionUUID, new ExecutionData(currentData.executionCount() + 1, currentData.windowStartTime(), now));
            log.debug("Recorded execution {} for player {} action {}", (Object)(currentData.executionCount() + 1), (Object)playerUUID, (Object)actionUUID);
        }
        this.setDirty();
    }

    public void resetExecution(UUID playerUUID, UUID actionUUID) {
        Map<UUID, ExecutionData> playerData = this.trackingData.get(playerUUID);
        if (playerData != null && playerData.remove(actionUUID) != null) {
            log.debug("Reset execution for player {} action {}", (Object)playerUUID, (Object)actionUUID);
            this.setDirty();
        }
    }

    public void resetExecutionForAllPlayers(UUID actionUUID) {
        int resetCount = 0;
        for (Map<UUID, ExecutionData> playerData : this.trackingData.values()) {
            if (playerData.remove(actionUUID) == null) continue;
            ++resetCount;
        }
        if (resetCount > 0) {
            log.debug("Reset execution for {} players for action {}", (Object)resetCount, (Object)actionUUID);
            this.setDirty();
        }
    }

    public void cleanupExpiredRecords() {
        long cutoffTime = System.currentTimeMillis() - ExecutionInterval.PER_MONTH.getMilliseconds();
        int removedCount = 0;
        for (Map<UUID, ExecutionData> playerData : this.trackingData.values()) {
            int beforeSize = playerData.size();
            playerData.entrySet().removeIf(entry -> ((ExecutionData)entry.getValue()).lastExecutionTime() < cutoffTime);
            removedCount += beforeSize - playerData.size();
        }
        this.trackingData.entrySet().removeIf(entry -> ((Map)entry.getValue()).isEmpty());
        if (removedCount > 0) {
            log.debug("Cleaned up {} expired execution records", (Object)removedCount);
            this.setDirty();
        }
    }
}

