/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.scale;

import de.markusbordihn.easynpc.data.model.ModelPartType;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public record CustomScale(float x, float y, float z) {
    public static final CustomScale DEFAULT = new CustomScale(1.0f, 1.0f, 1.0f);
    public static final StreamCodec<RegistryFriendlyByteBuf, CustomScale> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, CustomScale>(){

        public CustomScale decode(RegistryFriendlyByteBuf registryFriendlyByteBuf) {
            return new CustomScale(registryFriendlyByteBuf.readFloat(), registryFriendlyByteBuf.readFloat(), registryFriendlyByteBuf.readFloat());
        }

        public void encode(RegistryFriendlyByteBuf registryFriendlyByteBuf, CustomScale scale) {
            registryFriendlyByteBuf.writeFloat(scale.x);
            registryFriendlyByteBuf.writeFloat(scale.y);
            registryFriendlyByteBuf.writeFloat(scale.z);
        }
    };

    public CustomScale(ModelPartType modelPartType, CompoundTag compoundTag) {
        this(compoundTag.getListOrEmpty(modelPartType.getTagName()));
    }

    public CustomScale(ListTag listTag) {
        this(listTag != null && listTag.size() > 0 ? listTag.getFloat(0).orElse(Float.valueOf(1.0f)).floatValue() : 1.0f, listTag != null && listTag.size() > 1 ? listTag.getFloat(1).orElse(Float.valueOf(1.0f)).floatValue() : 1.0f, listTag != null && listTag.size() > 2 ? listTag.getFloat(2).orElse(Float.valueOf(1.0f)).floatValue() : 1.0f);
    }

    public CustomScale(List<Float> list) {
        this(list != null && list.size() > 0 ? list.get(0).floatValue() : 1.0f, list != null && list.size() > 1 ? list.get(1).floatValue() : 1.0f, list != null && list.size() > 2 ? list.get(2).floatValue() : 1.0f);
    }

    public CustomScale(float scale) {
        this(scale, scale, scale);
    }

    public ListTag save() {
        ListTag listTag = new ListTag();
        listTag.add((Object)FloatTag.valueOf((float)this.x));
        listTag.add((Object)FloatTag.valueOf((float)this.y));
        listTag.add((Object)FloatTag.valueOf((float)this.z));
        return listTag;
    }

    public boolean hasChanged() {
        return this.hasChanged(1.0f, 1.0f, 1.0f);
    }

    public boolean hasChanged(float x, float y, float z) {
        return this.x != x || this.y != y || this.z != z;
    }
}

