/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.screen;

import de.markusbordihn.easynpc.data.action.ActionEventSet;
import de.markusbordihn.easynpc.data.action.ActionEventType;
import de.markusbordihn.easynpc.data.dialog.DialogDataEntry;
import de.markusbordihn.easynpc.data.dialog.DialogDataSet;
import de.markusbordihn.easynpc.data.dialog.DialogTextData;
import de.markusbordihn.easynpc.data.scoreboard.ScoreboardData;
import de.markusbordihn.easynpc.data.screen.AdditionalScreenDataInterface;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;

public class AdditionalScreenData
implements AdditionalScreenDataInterface {
    private static final String ACTION_EVENT_DATA_TAG = "ActionEventData";
    private static final String ACTION_EVENT_TYPE_TAG = "ActionEventType";
    private static final String DIALOG_DATA_TAG = "DialogData";
    private static final String SCOREBOARD_DATA_TAG = "ScoreboardData";
    private final ActionEventSet actionEventSet;
    private final ActionEventType actionEventType;
    private final CompoundTag data;
    private final DialogDataSet dialogDataSet;
    private final ScoreboardData scoreboardData;

    public AdditionalScreenData(CompoundTag compoundTag) {
        this.actionEventSet = AdditionalScreenData.getActionEventSet(compoundTag);
        this.actionEventType = AdditionalScreenData.getActionEventType(compoundTag);
        this.dialogDataSet = AdditionalScreenData.getDialogDataSet(compoundTag);
        this.scoreboardData = AdditionalScreenData.getScoreboardData(compoundTag);
        this.data = compoundTag;
        this.data.remove(ACTION_EVENT_DATA_TAG);
        this.data.remove(ACTION_EVENT_TYPE_TAG);
        this.data.remove(DIALOG_DATA_TAG);
        this.data.remove(SCOREBOARD_DATA_TAG);
    }

    public static void addActionEventType(CompoundTag compoundTag, ActionEventType actionEventType) {
        if (compoundTag == null || actionEventType == null) {
            return;
        }
        compoundTag.putString(ACTION_EVENT_TYPE_TAG, actionEventType.name());
    }

    public static ActionEventType getActionEventType(CompoundTag compoundTag) {
        if (!AdditionalScreenData.hasActionEventType(compoundTag)) {
            return ActionEventType.NONE;
        }
        return ActionEventType.get(compoundTag.getString(ACTION_EVENT_TYPE_TAG).orElse(""));
    }

    public static boolean hasActionEventType(CompoundTag compoundTag) {
        return compoundTag != null && compoundTag.contains(ACTION_EVENT_TYPE_TAG);
    }

    public static void addActionEventSet(CompoundTag compoundTag, EasyNPC<?> easyNPC) {
        if (compoundTag == null || easyNPC == null || easyNPC.getEasyNPCActionEventData() == null) {
            return;
        }
        compoundTag.put(ACTION_EVENT_DATA_TAG, (Tag)easyNPC.getEasyNPCActionEventData().getActionEventSet().createTag());
    }

    public static ActionEventSet getActionEventSet(CompoundTag compoundTag) {
        if (!AdditionalScreenData.hasActionEventSet(compoundTag)) {
            return new ActionEventSet();
        }
        return new ActionEventSet(compoundTag.getCompoundOrEmpty(ACTION_EVENT_DATA_TAG));
    }

    public static boolean hasActionEventSet(CompoundTag compoundTag) {
        return compoundTag != null && compoundTag.contains(ACTION_EVENT_DATA_TAG);
    }

    public static void addDialogDataSet(CompoundTag compoundTag, EasyNPC<?> easyNPC) {
        if (compoundTag == null || easyNPC == null || easyNPC.getEasyNPCDialogData() == null) {
            return;
        }
        compoundTag.put(DIALOG_DATA_TAG, (Tag)easyNPC.getEasyNPCDialogData().getDialogDataSet().createTag());
    }

    public static DialogDataSet getDialogDataSet(CompoundTag compoundTag) {
        if (!AdditionalScreenData.hasDialogDataSet(compoundTag)) {
            return new DialogDataSet();
        }
        return new DialogDataSet(compoundTag.getCompoundOrEmpty(DIALOG_DATA_TAG));
    }

    public static boolean hasDialogDataSet(CompoundTag compoundTag) {
        return compoundTag != null && compoundTag.contains(DIALOG_DATA_TAG);
    }

    public static void addScoreboardData(CompoundTag compoundTag, ScoreboardData scoreboardData) {
        if (compoundTag == null || scoreboardData == null) {
            return;
        }
        compoundTag.put(SCOREBOARD_DATA_TAG, (Tag)scoreboardData.createTag());
    }

    public static ScoreboardData getScoreboardData(CompoundTag compoundTag) {
        if (!AdditionalScreenData.hasScoreboardData(compoundTag)) {
            return new ScoreboardData();
        }
        return new ScoreboardData(compoundTag.getCompoundOrEmpty(SCOREBOARD_DATA_TAG));
    }

    public static boolean hasScoreboardData(CompoundTag compoundTag) {
        return compoundTag != null && compoundTag.contains(SCOREBOARD_DATA_TAG);
    }

    public static void addDialogDataSet(CompoundTag compoundTag, EasyNPC<?> easyNPC, ServerPlayer serverPlayer) {
        Set<String> objectiveNames;
        if (compoundTag == null || easyNPC == null || easyNPC.getEasyNPCDialogData() == null) {
            return;
        }
        DialogDataSet dialogDataSet = easyNPC.getEasyNPCDialogData().getDialogDataSet();
        compoundTag.put(DIALOG_DATA_TAG, (Tag)dialogDataSet.createTag());
        if (serverPlayer != null && !(objectiveNames = AdditionalScreenData.extractObjectiveNamesFromDialogDataSet(dialogDataSet)).isEmpty()) {
            ScoreboardData scoreboardData = new ScoreboardData(serverPlayer, objectiveNames);
            AdditionalScreenData.addScoreboardData(compoundTag, scoreboardData);
        }
    }

    private static Set<String> extractObjectiveNamesFromDialogDataSet(DialogDataSet dialogDataSet) {
        HashSet<String> objectiveNames = new HashSet<String>();
        if (dialogDataSet == null || !dialogDataSet.hasDialog()) {
            return objectiveNames;
        }
        for (DialogDataEntry dialogEntry : dialogDataSet.getDialogsByLabel()) {
            if (dialogEntry == null || dialogEntry.getDialogTexts() == null) continue;
            for (DialogTextData dialogTextData : dialogEntry.getDialogTexts()) {
                if (dialogTextData == null || dialogTextData.text() == null) continue;
                objectiveNames.addAll(ScoreboardData.parseScoreMacros(dialogTextData.text()));
            }
        }
        return objectiveNames;
    }

    @Override
    public ActionEventType getActionEventType() {
        return this.actionEventType;
    }

    @Override
    public ActionEventSet getActionEventSet() {
        return this.actionEventSet;
    }

    @Override
    public DialogDataSet getDialogDataSet() {
        return this.dialogDataSet;
    }

    @Override
    public CompoundTag getData() {
        return this.data;
    }

    public CompoundTag get(String dataTag) {
        if (this.data.contains(dataTag)) {
            return this.data.getCompoundOrEmpty(dataTag);
        }
        return new CompoundTag();
    }

    public ListTag getList(String dataTag) {
        if (this.data.contains(dataTag)) {
            return this.data.getListOrEmpty(dataTag);
        }
        return new ListTag();
    }

    @Override
    public boolean hasDialogDataSet() {
        return this.dialogDataSet != null;
    }

    @Override
    public ScoreboardData getScoreboardData() {
        return this.scoreboardData;
    }
}

