/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.attribute.EntityAttributes;
import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.network.syncher.EntityDataSerializersManager;
import java.util.EnumMap;
import net.minecraft.core.Holder;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public interface AttributeDataCapable<E extends PathfinderMob>
extends EasyNPC<E> {
    public static void registerSyncedAttributeData(EnumMap<SynchedDataIndex, EntityDataAccessor<?>> map, Class<? extends Entity> entityClass) {
        log.info("- Registering Synched Attribute Data for {}.", (Object)entityClass.getSimpleName());
        map.put(SynchedDataIndex.ENTITY_ATTRIBUTES, SynchedEntityData.defineId(entityClass, EntityDataSerializersManager.ENTITY_ATTRIBUTES));
    }

    default public void setBaseAttribute(Holder<Attribute> attribute, double value) {
        if (attribute == null || this.getLivingEntity().getAttribute(attribute) == null) {
            return;
        }
        this.getLivingEntity().getAttribute(attribute).setBaseValue(value);
    }

    default public double getBaseAttribute(Holder<Attribute> attribute) {
        if (attribute == null || this.getLivingEntity().getAttribute(attribute) == null) {
            return 0.0;
        }
        return this.getLivingEntity().getAttribute(attribute).getBaseValue();
    }

    default public EntityAttributes getEntityAttributes() {
        return (EntityAttributes)this.getSynchedEntityData(SynchedDataIndex.ENTITY_ATTRIBUTES);
    }

    default public void setEntityAttributes(EntityAttributes entityAttributes) {
        this.setSynchedEntityData(SynchedDataIndex.ENTITY_ATTRIBUTES, entityAttributes);
    }

    default public void refreshEntityAttributes() {
        EntityAttributes entityAttributes = this.getEntityAttributes();
        if (entityAttributes != null) {
            this.setEntityAttributes(new EntityAttributes());
            this.setEntityAttributes(entityAttributes);
        }
    }

    default public boolean getAttributeSilent() {
        return this.getEntity().isSilent();
    }

    default public void setAttributeSilent(boolean silent) {
        this.getEntity().setSilent(silent);
    }

    default public void defineSynchedAttributeData(SynchedEntityData.Builder builder) {
        this.defineSynchedEntityData(builder, SynchedDataIndex.ENTITY_ATTRIBUTES, new EntityAttributes());
    }

    default public void addAdditionalAttributeData(ValueOutput valueOutput) {
        EntityAttributes entityAttributes = this.getEntityAttributes();
        if (entityAttributes != null) {
            entityAttributes.save(valueOutput);
        }
    }

    default public void readAdditionalAttributeData(ValueInput valueInput) {
        this.setEntityAttributes(new EntityAttributes(valueInput));
    }
}

