/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.model.ModelType;
import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelPositionDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelRotationDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelScaleDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelVisibilityDataCapable;
import de.markusbordihn.easynpc.network.syncher.EntityDataSerializersManager;
import java.util.EnumMap;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public interface ModelDataCapable<T extends PathfinderMob>
extends EasyNPC<T>,
ModelPositionDataCapable<T>,
ModelRotationDataCapable<T>,
ModelScaleDataCapable<T>,
ModelVisibilityDataCapable<T> {
    public static final String EASY_NPC_DATA_MODEL_DATA_TAG = "ModelData";
    public static final String EASY_NPC_DATA_MODEL_DEFAULT_POSE_TAG = "DefaultPose";
    public static final String EASY_NPC_DATA_MODEL_POSE_TAG = "Pose";

    public static void registerSyncedModelData(EnumMap<SynchedDataIndex, EntityDataAccessor<?>> map, Class<? extends Entity> entityClass) {
        log.info("Registering Synched Model Data for {}.", (Object)entityClass.getSimpleName());
        map.put(SynchedDataIndex.MODEL_POSE, SynchedEntityData.defineId(entityClass, EntityDataSerializersManager.MODEL_POSE));
        ModelPositionDataCapable.registerSyncedModelPositionData(map, entityClass);
        ModelRotationDataCapable.registerSyncedModelRotationData(map, entityClass);
        ModelScaleDataCapable.registerSyncedModelScaleData(map, entityClass);
        ModelVisibilityDataCapable.registerSyncedModelVisibilityData(map, entityClass);
    }

    default public Pose getDefaultPose() {
        return this.getEntity().getPose();
    }

    default public void setDefaultPose(Pose pose) {
        this.getEntity().setPose(pose);
    }

    default public ModelPose getModelPose() {
        return (ModelPose)((Object)this.getSynchedEntityData(SynchedDataIndex.MODEL_POSE));
    }

    default public void setModelPose(ModelPose modelPose) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_POSE, modelPose);
    }

    default public ModelType getModelType() {
        return ModelType.HUMANOID;
    }

    default public boolean canUseArmor() {
        return false;
    }

    default public boolean canUseMainHand() {
        return true;
    }

    default public boolean canUseOffHand() {
        return true;
    }

    default public boolean hasChangedModel() {
        return this.hasChangedModelPosition() || this.hasChangedModelRotation() || this.hasChangedModelScale() || this.hasChangedModelVisibility();
    }

    default public void defineSynchedModelData(SynchedEntityData.Builder builder) {
        this.defineSynchedEntityData(builder, SynchedDataIndex.MODEL_POSE, ModelPose.DEFAULT);
        this.defineSynchedModelPositionData(builder);
        this.defineSynchedModelRotationData(builder);
        this.defineSynchedModelScaleData(builder);
        this.defineSynchedModelVisibilityData(builder);
    }

    default public void addAdditionalModelData(ValueOutput valueOutput) {
        CompoundTag modelDataTag = new CompoundTag();
        if (this.getModelPose() != ModelPose.DEFAULT && this.hasChangedModel()) {
            modelDataTag.putString(EASY_NPC_DATA_MODEL_POSE_TAG, this.getModelPose().name());
            modelDataTag.putString(EASY_NPC_DATA_MODEL_DEFAULT_POSE_TAG, Pose.STANDING.name());
        } else {
            modelDataTag.putString(EASY_NPC_DATA_MODEL_POSE_TAG, ModelPose.DEFAULT.name());
            modelDataTag.putString(EASY_NPC_DATA_MODEL_DEFAULT_POSE_TAG, this.getDefaultPose() != null ? this.getDefaultPose().name() : Pose.STANDING.name());
        }
        this.addAdditionalModelPositionData(modelDataTag);
        this.addAdditionalModelRotationData(modelDataTag);
        this.addAdditionalModelScaleData(modelDataTag);
        this.addAdditionalModelVisibilityData(modelDataTag);
        valueOutput.store(EASY_NPC_DATA_MODEL_DATA_TAG, CompoundTag.CODEC, (Object)modelDataTag);
    }

    default public void readAdditionalModelData(ValueInput valueInput) {
        String defaultPose;
        String modelPose;
        Optional compoundTagData = valueInput.read(EASY_NPC_DATA_MODEL_DATA_TAG, CompoundTag.CODEC);
        if (compoundTagData.isEmpty()) {
            return;
        }
        CompoundTag modelDataTag = (CompoundTag)compoundTagData.get();
        if (modelDataTag.contains(EASY_NPC_DATA_MODEL_POSE_TAG) && !(modelPose = modelDataTag.getString(EASY_NPC_DATA_MODEL_POSE_TAG).orElse("")).isEmpty()) {
            this.setModelPose(ModelPose.get(modelPose));
        }
        if (this.getModelPose() == ModelPose.DEFAULT && modelDataTag.contains(EASY_NPC_DATA_MODEL_DEFAULT_POSE_TAG) && !(defaultPose = modelDataTag.getString(EASY_NPC_DATA_MODEL_DEFAULT_POSE_TAG).orElse("")).isEmpty()) {
            this.setDefaultPose(Pose.valueOf((String)defaultPose));
        }
        this.readAdditionalModelPositionData(modelDataTag);
        this.readAdditionalModelRotationData(modelDataTag);
        this.readAdditionalModelScaleData(modelDataTag);
        this.readAdditionalModelVisibilityData(modelDataTag);
    }
}

