/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.render.RenderDataSet;
import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.network.syncher.EntityDataSerializersManager;
import java.util.EnumMap;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public interface RenderDataCapable<E extends PathfinderMob>
extends EasyNPC<E> {
    public static final String DATA_RENDER_DATA_TAG = "RenderData";

    public static void registerSyncedRenderData(EnumMap<SynchedDataIndex, EntityDataAccessor<?>> map, Class<? extends Entity> entityClass) {
        log.info("- Registering Synched Render Data for {}.", (Object)entityClass.getSimpleName());
        map.put(SynchedDataIndex.RENDER_DATA, SynchedEntityData.defineId(entityClass, EntityDataSerializersManager.RENDER_DATA_SET));
    }

    default public void defineSynchedRenderData(SynchedEntityData.Builder builder) {
        this.defineSynchedEntityData(builder, SynchedDataIndex.RENDER_DATA, new RenderDataSet());
    }

    default public RenderDataSet getRenderDataSet() {
        return (RenderDataSet)this.getSynchedEntityData(SynchedDataIndex.RENDER_DATA);
    }

    default public void setRenderData(RenderDataSet renderData) {
        this.setSynchedEntityData(SynchedDataIndex.RENDER_DATA, renderData);
    }

    default public void updateRenderData() {
        RenderDataSet renderDataSet = this.getRenderDataSet();
        this.setRenderData(new RenderDataSet());
        this.setRenderData(renderDataSet);
    }

    default public void addAdditionalRenderData(ValueOutput valueOutput) {
        CompoundTag renderTag = new CompoundTag();
        RenderDataSet renderData = this.getRenderDataSet();
        if (renderData != null) {
            renderData.save(renderTag);
        }
        valueOutput.store(DATA_RENDER_DATA_TAG, CompoundTag.CODEC, (Object)renderTag);
    }

    default public void readAdditionalRenderData(ValueInput valueInput) {
        Optional compoundTagData = valueInput.read(DATA_RENDER_DATA_TAG, CompoundTag.CODEC);
        if (compoundTagData.isEmpty()) {
            return;
        }
        RenderDataSet renderData = new RenderDataSet((CompoundTag)compoundTagData.get());
        this.setRenderData(renderData);
    }
}

