/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.handler;

import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.utils.CompoundTagUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueOutput;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RespawnHandler {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    private RespawnHandler() {
    }

    public static boolean respawnNPC(EasyNPC<?> easyNPC, ServerLevel serverLevel) {
        if (easyNPC == null || serverLevel == null) {
            log.error("[{}] Error respawning NPC.", easyNPC);
            return false;
        }
        TagValueOutput tagValueOutput = TagValueOutput.createWithoutContext((ProblemReporter)ProblemReporter.DISCARDING);
        easyNPC.getEntity().saveWithoutId((ValueOutput)tagValueOutput);
        CompoundTag compoundTag = tagValueOutput.buildResult();
        EntityType entityType = easyNPC.getEntity().getType();
        Entity entity = entityType.create((Level)serverLevel, EntitySpawnReason.TRIGGERED);
        if (entity == null) {
            log.error("[{}] Unable to create new entity with type {} with {}", easyNPC, (Object)entityType, (Object)serverLevel);
            return false;
        }
        entity.load(TagValueInput.create((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)serverLevel.registryAccess(), (CompoundTag)compoundTag));
        CompoundTagUtils.fixLegacyCustomName(entity, compoundTag);
        easyNPC.getEntity().discard();
        log.info("[{}] Respawn Easy NPC with {} into {}", easyNPC, (Object)entityType, (Object)serverLevel);
        serverLevel.addFreshEntity(entity);
        return true;
    }
}

