/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network;

import de.markusbordihn.easynpc.network.NetworkHandlerManager;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface NetworkHandlerInterface {
    public static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    public static final String LOG_PREFIX = "[NetworkHandler]";
    public static final int PROTOCOL_VERSION = 24;

    public <M extends NetworkMessageRecord> void registerClientNetworkMessageHandler(CustomPacketPayload.Type<M> var1, StreamCodec<RegistryFriendlyByteBuf, M> var2, Class<M> var3, Function<FriendlyByteBuf, M> var4);

    public <M extends NetworkMessageRecord> void registerServerNetworkMessageHandler(CustomPacketPayload.Type<M> var1, StreamCodec<RegistryFriendlyByteBuf, M> var2, Class<M> var3, Function<FriendlyByteBuf, M> var4);

    public <M extends NetworkMessageRecord> void sendToServer(M var1);

    public <M extends NetworkMessageRecord> void sendToPlayer(M var1, ServerPlayer var2);

    public <M extends NetworkMessageRecord> void addClientMessage(CustomPacketPayload.Type<M> var1, Class<M> var2);

    public <M extends NetworkMessageRecord> void addServerMessage(CustomPacketPayload.Type<M> var1, Class<M> var2);

    public Map<CustomPacketPayload.Type<?>, Class<? extends NetworkMessageRecord>> getClientMessages();

    public Map<CustomPacketPayload.Type<?>, Class<? extends NetworkMessageRecord>> getServerMessages();

    public <M extends NetworkMessageRecord> void addRegisteredClientMessage(CustomPacketPayload.Type<M> var1, Class<M> var2);

    public <M extends NetworkMessageRecord> void addRegisteredServerMessage(CustomPacketPayload.Type<M> var1, Class<M> var2);

    public Map<CustomPacketPayload.Type<?>, Class<? extends NetworkMessageRecord>> getRegisteredClientMessages();

    public Map<CustomPacketPayload.Type<?>, Class<? extends NetworkMessageRecord>> getRegisteredServerMessages();

    default public <M extends NetworkMessageRecord> void registerClientPayloadType(CustomPacketPayload.Type<M> type, StreamCodec<RegistryFriendlyByteBuf, M> codec) {
    }

    default public <M extends NetworkMessageRecord> void registerServerPayloadType(CustomPacketPayload.Type<M> type, StreamCodec<RegistryFriendlyByteBuf, M> codec) {
    }

    default public boolean sendMessageToPlayer(NetworkMessageRecord networkMessageRecord, ServerPlayer serverPlayer) {
        if (!this.hasClientMessage(networkMessageRecord.type())) {
            log.error("{} Message {} is not registered as client message", (Object)LOG_PREFIX, (Object)networkMessageRecord.type());
            return false;
        }
        try {
            this.sendToPlayer(networkMessageRecord, serverPlayer);
        }
        catch (Exception e) {
            log.error("{} Failed to send message {} to player {}", (Object)LOG_PREFIX, (Object)networkMessageRecord.id(), (Object)serverPlayer.getName().getString(), (Object)e);
            return false;
        }
        return true;
    }

    default public boolean sendMessageToServer(NetworkMessageRecord networkMessageRecord) {
        if (!this.hasServerMessage(networkMessageRecord.type())) {
            log.error("{} Message {} is not registered as server message", (Object)LOG_PREFIX, (Object)networkMessageRecord.type());
            return false;
        }
        if (Minecraft.getInstance().getConnection() == null) {
            log.error("{} Failed to send message {} to server: No connection available", (Object)LOG_PREFIX, (Object)networkMessageRecord.type());
            return false;
        }
        try {
            this.sendToServer(networkMessageRecord);
        }
        catch (Exception e) {
            log.error("{} Failed to send message {} to server", (Object)LOG_PREFIX, (Object)networkMessageRecord.id(), (Object)e);
            return false;
        }
        return true;
    }

    default public boolean hasClientMessage(CustomPacketPayload.Type<?> messageID) {
        return this.getClientMessages().containsKey(messageID);
    }

    default public boolean hasServerMessage(CustomPacketPayload.Type<?> messageID) {
        return this.getServerMessages().containsKey(messageID);
    }

    default public Class<? extends NetworkMessageRecord> getRegisteredClientMessage(CustomPacketPayload.Type<?> messageID) {
        return this.getRegisteredClientMessages().get(messageID);
    }

    default public Class<? extends NetworkMessageRecord> getRegisteredServerMessage(CustomPacketPayload.Type<?> messageID) {
        return this.getRegisteredServerMessages().get(messageID);
    }

    default public CustomPacketPayload.Type<?> getRegisteredClientMessageId(Class<? extends NetworkMessageRecord> networkMessage) {
        return this.getRegisteredClientMessages().entrySet().stream().filter(entry -> ((Class)entry.getValue()).equals(networkMessage)).map(Map.Entry::getKey).findFirst().orElse(null);
    }

    default public CustomPacketPayload.Type<?> getRegisteredServerMessageId(Class<? extends NetworkMessageRecord> networkMessage) {
        return this.getRegisteredServerMessages().entrySet().stream().filter(entry -> ((Class)entry.getValue()).equals(networkMessage)).map(Map.Entry::getKey).findFirst().orElse(null);
    }

    default public boolean hasRegisteredClientMessage(CustomPacketPayload.Type<?> messageID) {
        return this.getRegisteredClientMessages().containsKey(messageID);
    }

    default public boolean hasRegisteredClientMessage(Class<? extends NetworkMessageRecord> networkMessage) {
        return this.getRegisteredClientMessages().containsValue(networkMessage);
    }

    default public boolean hasRegisteredServerMessage(CustomPacketPayload.Type<?> messageID) {
        return this.getRegisteredServerMessages().containsKey(messageID);
    }

    default public boolean hasRegisteredServerMessage(Class<? extends NetworkMessageRecord> networkMessage) {
        return this.getRegisteredServerMessages().containsValue(networkMessage);
    }

    default public <M extends NetworkMessageRecord> void registerServerNetworkMessage(CustomPacketPayload.Type<M> type, StreamCodec<RegistryFriendlyByteBuf, M> codec, Class<M> networkMessage, Function<FriendlyByteBuf, M> creator) {
        if (!this.hasServerMessage(type)) {
            this.registerServerPayloadType(type, codec);
        }
        if (NetworkHandlerManager.isServerNetworkHandler()) {
            if (this.hasRegisteredServerMessage(type)) {
                log.error("{} Server network message id {} already registered with {}", (Object)LOG_PREFIX, type, this.getRegisteredServerMessage(type));
                return;
            }
            if (this.hasRegisteredServerMessage(networkMessage)) {
                log.error("{} Server network message {} already registered with id {}", (Object)LOG_PREFIX, networkMessage, this.getRegisteredServerMessageId(networkMessage));
                return;
            }
            try {
                this.registerServerNetworkMessageHandler(type, codec, networkMessage, creator);
                this.addRegisteredServerMessage(type, networkMessage);
            }
            catch (Exception e) {
                log.error("{} Failed to register server network message id {} with {}", (Object)LOG_PREFIX, type, networkMessage, (Object)e);
                return;
            }
        }
        this.addServerMessage(type, networkMessage);
    }

    default public <M extends NetworkMessageRecord> void registerClientNetworkMessage(CustomPacketPayload.Type<M> type, StreamCodec<RegistryFriendlyByteBuf, M> codec, Class<M> networkMessage, Function<FriendlyByteBuf, M> creator) {
        if (!this.hasClientMessage(type)) {
            this.registerClientPayloadType(type, codec);
        }
        if (NetworkHandlerManager.isClientNetworkHandler()) {
            if (this.hasRegisteredClientMessage(type)) {
                log.error("{} Client network message id {} already registered with {}", (Object)LOG_PREFIX, type, this.getRegisteredClientMessage(type));
                return;
            }
            if (this.hasRegisteredClientMessage(networkMessage)) {
                log.error("{} Client network message {} already registered with id {}", (Object)LOG_PREFIX, networkMessage, this.getRegisteredClientMessageId(networkMessage));
                return;
            }
            try {
                this.registerClientNetworkMessageHandler(type, codec, networkMessage, creator);
                this.addRegisteredClientMessage(type, networkMessage);
            }
            catch (Exception e) {
                log.error("{} Failed to register client network message id {} with {}", (Object)LOG_PREFIX, type, networkMessage, (Object)e);
                return;
            }
        }
        this.addClientMessage(type, networkMessage);
    }

    default public void logRegisterClientNetworkMessageHandler(CustomPacketPayload.Type<?> messageID, Class<?> networkMessage) {
        log.info("{} Registering client network message {} with {}", (Object)LOG_PREFIX, (Object)networkMessage.getSimpleName(), messageID);
    }

    default public void logRegisterClientNetworkMessageHandler(CustomPacketPayload.Type<?> messageID, Class<?> networkMessage, int registrationID) {
        log.info("{} Registering client network message {} with {} ({})", (Object)LOG_PREFIX, (Object)networkMessage.getSimpleName(), messageID, (Object)registrationID);
    }

    default public void logRegisterServerNetworkMessageHandler(CustomPacketPayload.Type<?> messageID, Class<?> networkMessage) {
        log.info("{} Registering server network message {} with {}", (Object)LOG_PREFIX, (Object)networkMessage.getSimpleName(), messageID);
    }

    default public void logRegisterServerNetworkMessageHandler(CustomPacketPayload.Type<?> messageID, Class<?> networkMessage, int registrationID) {
        log.info("{} Registering server network message {} with {} ({})", (Object)LOG_PREFIX, (Object)networkMessage.getSimpleName(), messageID, (Object)registrationID);
    }
}

