/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.UUID;

public class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static boolean invokeMethod(Object object, String[] methodNames, Class<?>[] parameterTypes, Object ... args) {
        for (String methodName : methodNames) {
            if (!ReflectionUtils.invokeMethod(object, methodName, parameterTypes, args)) continue;
            return true;
        }
        return false;
    }

    public static boolean invokeMethod(Object object, String methodName, Class<?>[] parameterTypes, Object ... args) {
        try {
            Method method = object.getClass().getDeclaredMethod(methodName, parameterTypes);
            method.setAccessible(true);
            method.invoke(object, args);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean changeIntValueField(Object object, String[] fieldNames, int value) {
        for (String fieldName : fieldNames) {
            if (!ReflectionUtils.changeIntValueField(object, fieldName, value)) continue;
            return true;
        }
        return false;
    }

    public static boolean changeIntValueField(Object object, String fieldName, int value) {
        try {
            Field field = object.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            field.setInt(object, value);
            return true;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return false;
        }
    }

    public static UUID getUUIDValueField(Object object, String fieldName) {
        try {
            Field field = object.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            return (UUID)field.get(object);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return null;
        }
    }

    public static UUID getUUIDValueField(Object object, String[] fieldNames) {
        for (String fieldName : fieldNames) {
            UUID uuid = ReflectionUtils.getUUIDValueField(object, fieldName);
            if (uuid == null) continue;
            return uuid;
        }
        return null;
    }
}

