/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.components;

import de.markusbordihn.easynpc.network.components.TextComponent;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;

public class Text {
    private Text() {
    }

    public static void drawString(GuiGraphics guiGraphics, Font font, String text, int x, int y) {
        Text.drawString(guiGraphics, font, text, x, y, 0x404040);
    }

    public static void drawString(GuiGraphics guiGraphics, Font font, Component component, int x, int y) {
        Text.drawString(guiGraphics, font, component, x, y, 0x404040);
    }

    public static void drawString(GuiGraphics guiGraphics, Font font, Component component, int x, int y, int color) {
        guiGraphics.drawString(font, component, x, y, color, false);
    }

    public static void drawStringShadow(GuiGraphics guiGraphics, Font font, String text, int x, int y, int color) {
        guiGraphics.drawString(font, text, x, y, color, true);
    }

    public static void drawStringShadow(GuiGraphics guiGraphics, Font font, Component component, int x, int y, int color) {
        guiGraphics.drawString(font, component, x, y, color, true);
    }

    public static void drawString(GuiGraphics guiGraphics, Font font, FormattedCharSequence formattedCharSequence, int x, int y) {
        Text.drawString(guiGraphics, font, formattedCharSequence, x, y, 0x404040);
    }

    public static void drawErrorMessage(GuiGraphics guiGraphics, Font font, String text, int x, int y, int width) {
        if (text == null) {
            return;
        }
        Text.drawErrorMessage(guiGraphics, font, text, x, y, width);
    }

    public static void drawErrorMessage(GuiGraphics guiGraphics, Font font, Component component, int x, int y, int width) {
        List textComponents = font.split((FormattedText)component, width);
        int line = 0;
        for (FormattedCharSequence formattedCharSequence : textComponents) {
            int n = line++;
            Objects.requireNonNull(font);
            Text.drawString(guiGraphics, font, formattedCharSequence, x, y + n * (9 + 2), 0xFF5555);
        }
    }

    public static void drawString(GuiGraphics guiGraphics, Font font, String text, int x, int y, int color) {
        guiGraphics.drawString(font, text, x, y, color, false);
    }

    public static void drawString(GuiGraphics guiGraphics, Font font, FormattedCharSequence formattedCharSequence, int x, int y, int color) {
        guiGraphics.drawString(font, formattedCharSequence, x, y, color, false);
    }

    public static void drawConfigString(GuiGraphics guiGraphics, Font font, String translationKey, int x, int y) {
        Text.drawConfigString(guiGraphics, font, translationKey, x, y, 0x404040);
    }

    public static void drawConfigString(GuiGraphics guiGraphics, Font font, String translationKey, int x, int y, int color) {
        Text.drawString(guiGraphics, font, (Component)TextComponent.getTranslatedConfigText(translationKey), x, y, color);
    }

    public static void drawConfigStringShadow(GuiGraphics guiGraphics, Font font, String translationKey, int x, int y, int color) {
        Text.drawStringShadow(guiGraphics, font, (Component)TextComponent.getTranslatedConfigText(translationKey), x, y, color);
    }

    public static void drawConfigStringShadowWithData(GuiGraphics guiGraphics, Font font, String translationKey, String data, int x, int y, int color) {
        Text.drawStringShadow(guiGraphics, font, (Component)TextComponent.getTranslatedConfigText(translationKey, data), x, y, color);
    }
}

