/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.configuration;

import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import java.util.EnumSet;
import java.util.Set;

public record ConfigurationData(Set<ConfigurationType> enabledTypes) {
    private static final Set<ConfigurationType> ALL_TYPES = EnumSet.allOf(ConfigurationType.class);
    public static final ConfigurationData STANDARD = new ConfigurationData(ConfigurationData.exclude(ALL_TYPES, ConfigurationType.PLAYER_SKIN));
    public static final ConfigurationData RAW = new ConfigurationData(ConfigurationData.exclude(STANDARD.enabledTypes(), ConfigurationType.BASIC_OBJECTIVE, ConfigurationType.ATTACK_OBJECTIVE, ConfigurationType.FOLLOW_OBJECTIVE, ConfigurationType.LOOK_OBJECTIVE, ConfigurationType.DEFAULT_MODEL, ConfigurationType.CUSTOM_MODEL));
    public static final ConfigurationData EPIC_FIGHT = new ConfigurationData(ConfigurationData.exclude(STANDARD.enabledTypes(), ConfigurationType.ADVANCED_POSE, ConfigurationType.BASIC_POSE, ConfigurationType.DEFAULT_POSE, ConfigurationType.POSE, ConfigurationType.BASIC_OBJECTIVE, ConfigurationType.ATTACK_OBJECTIVE, ConfigurationType.FOLLOW_OBJECTIVE, ConfigurationType.LOOK_OBJECTIVE, ConfigurationType.SCALING, ConfigurationType.DEFAULT_ROTATION, ConfigurationType.DEFAULT_MODEL, ConfigurationType.CUSTOM_MODEL));
    public static final ConfigurationData DOPPLER = new ConfigurationData(ConfigurationData.exclude(STANDARD.enabledTypes(), ConfigurationType.ADVANCED_POSE, ConfigurationType.BASIC_POSE, ConfigurationType.DEFAULT_POSE, ConfigurationType.POSE, ConfigurationType.SKIN, ConfigurationType.DEFAULT_SKIN, ConfigurationType.CUSTOM_SKIN, ConfigurationType.PLAYER_SKIN, ConfigurationType.URL_SKIN, ConfigurationType.NONE_SKIN, ConfigurationType.SCALING, ConfigurationType.DEFAULT_ROTATION));
    public static final ConfigurationData HUMANOID = new ConfigurationData(EnumSet.copyOf(ALL_TYPES));

    private static EnumSet<ConfigurationType> exclude(Set<ConfigurationType> base, ConfigurationType ... types) {
        EnumSet<ConfigurationType> result = EnumSet.copyOf(base);
        for (ConfigurationType type : types) {
            result.remove((Object)type);
        }
        return result;
    }

    public boolean isEnabled(ConfigurationType type) {
        return this.enabledTypes.contains((Object)type);
    }
}

