/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.gametest;

import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GameTestHelpers {
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    private GameTestHelpers() {
    }

    public static ServerPlayer mockServerPlayer(GameTestHelper helper, Vec3 position) {
        Player player = helper.makeMockPlayer(GameType.DEFAULT_MODE);
        if (!(player instanceof ServerPlayer)) {
            helper.fail((Component)Component.literal((String)"Failed to create ServerPlayer!"));
            return null;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        GameTestHelpers.assertNotNull(helper, "ServerPlayer is null!", serverPlayer);
        serverPlayer.setPos(helper.absoluteVec(position));
        helper.assertEntityPresent(serverPlayer.getType(), new BlockPos((int)position.x, (int)position.y, (int)position.z));
        return serverPlayer;
    }

    public static EasyNPC<?> mockEasyNPC(GameTestHelper helper, EntityType<? extends PathfinderMob> entityType, Vec3 position) {
        EasyNPC<?> easyNPC = GameTestHelpers.spawnNPCEntityType(helper, entityType);
        GameTestHelpers.assertNotNull(helper, "EasyNPC is null!", easyNPC);
        easyNPC.getEntity().setPos(helper.absoluteVec(position));
        helper.assertEntityPresent(easyNPC.getEntity().getType(), new BlockPos((int)position.x, (int)position.y, (int)position.z));
        return easyNPC;
    }

    public static EasyNPC<?> spawnNPCEntityType(GameTestHelper helper, EntityType<? extends PathfinderMob> entityType) {
        Object entity = GameTestHelpers.spawnEntityType(helper, entityType);
        if (entity instanceof EasyNPC) {
            EasyNPC easyNPC = (EasyNPC)entity;
            return easyNPC;
        }
        helper.fail((Component)Component.literal((String)("Entity " + String.valueOf(entityType) + " is not an EasyNPC!")));
        return null;
    }

    public static <T extends Entity> T spawnEntityType(GameTestHelper helper, EntityType<? extends PathfinderMob> entityType) {
        if (entityType == null) {
            helper.fail((Component)Component.literal((String)"EntityType is null!"));
            return null;
        }
        Player player = helper.makeMockPlayer(GameType.DEFAULT_MODE);
        Entity entity = entityType.create(player.level(), EntitySpawnReason.COMMAND);
        if (entity == null) {
            helper.fail((Component)Component.literal((String)("Entity for " + String.valueOf(entityType) + " is null!")));
            return null;
        }
        if (!player.level().addFreshEntity(entity)) {
            helper.fail((Component)Component.literal((String)("Failed to spawn entity " + String.valueOf(entityType) + "!")));
            return null;
        }
        return (T)entity;
    }

    public static void assertEquals(GameTestHelper helper, String message, Object expected, Object actual) {
        if (expected.equals(actual)) {
            helper.succeed();
        } else {
            helper.fail((Component)Component.literal((String)message));
        }
    }

    public static void assertTrue(GameTestHelper helper, String message, boolean condition) {
        if (condition) {
            helper.succeed();
        } else {
            helper.fail((Component)Component.literal((String)message));
        }
    }

    public static void assertNotNull(GameTestHelper helper, String message, Object object) {
        GameTestHelpers.assertTrue(helper, message, object != null);
    }
}

