/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.commands.suggestion;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.markusbordihn.easynpc.io.CustomPresetDataFiles;
import de.markusbordihn.easynpc.io.DataPresetDataFiles;
import de.markusbordihn.easynpc.io.DefaultPresetDataFiles;
import de.markusbordihn.easynpc.io.WorldPresetDataFiles;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2168;
import net.minecraft.class_2172;

public class PresetSuggestions {
    private static final long REFRESH_COOLDOWN_MS = 5000L;
    private static long lastCustomRefreshTime = 0L;
    private static long lastWorldRefreshTime = 0L;

    private PresetSuggestions() {
    }

    public static CompletableFuture<Suggestions> suggest(CommandContext<class_2168> context, SuggestionsBuilder build) {
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastWorldRefreshTime >= 5000L) {
            WorldPresetDataFiles.refreshPresetResourceLocations();
            lastWorldRefreshTime = currentTime;
        }
        return class_2172.method_9257(WorldPresetDataFiles.getPresetResourceLocations(), (SuggestionsBuilder)build);
    }

    public static CompletableFuture<Suggestions> suggestCustom(CommandContext<class_2168> context, SuggestionsBuilder build) {
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastCustomRefreshTime >= 5000L) {
            CustomPresetDataFiles.refreshPresetResourceLocations();
            lastCustomRefreshTime = currentTime;
        }
        return class_2172.method_9257(CustomPresetDataFiles.getPresetResourceLocations(), (SuggestionsBuilder)build);
    }

    public static CompletableFuture<Suggestions> suggestData(CommandContext<class_2168> context, SuggestionsBuilder build) {
        return class_2172.method_9257(DataPresetDataFiles.getPresetResourceLocations(((class_2168)context.getSource()).method_9211()), (SuggestionsBuilder)build);
    }

    public static CompletableFuture<Suggestions> suggestDefault(CommandContext<class_2168> context, SuggestionsBuilder build) {
        return class_2172.method_9257(DefaultPresetDataFiles.getPresetResourceLocations(((class_2168)context.getSource()).method_9211()), (SuggestionsBuilder)build);
    }

    public static CompletableFuture<Suggestions> suggestWorld(CommandContext<class_2168> context, SuggestionsBuilder build) {
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastWorldRefreshTime >= 5000L) {
            WorldPresetDataFiles.refreshPresetResourceLocations();
            lastWorldRefreshTime = currentTime;
        }
        return class_2172.method_9257(WorldPresetDataFiles.getPresetResourceLocations(), (SuggestionsBuilder)build);
    }
}

