/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.objective;

import de.markusbordihn.easynpc.data.objective.ObjectiveDataEntry;
import de.markusbordihn.easynpc.data.objective.ObjectiveType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.ai.goal.BowAttackGoal;
import de.markusbordihn.easynpc.entity.easynpc.ai.goal.CrossbowAttackGoal;
import de.markusbordihn.easynpc.entity.easynpc.ai.goal.CustomLookAtPlayerGoal;
import de.markusbordihn.easynpc.entity.easynpc.ai.goal.CustomMeleeAttackGoal;
import de.markusbordihn.easynpc.entity.easynpc.ai.goal.CustomOwnerHurtByTargetGoal;
import de.markusbordihn.easynpc.entity.easynpc.ai.goal.FollowLivingEntityGoal;
import de.markusbordihn.easynpc.entity.easynpc.ai.goal.GunAttackGoal;
import de.markusbordihn.easynpc.entity.easynpc.ai.goal.MoveBackToHomeGoal;
import de.markusbordihn.easynpc.entity.easynpc.ai.goal.RandomStrollAroundGoal;
import de.markusbordihn.easynpc.entity.easynpc.ai.goal.RandomStrollAroundHomeGoal;
import de.markusbordihn.easynpc.entity.easynpc.ai.goal.ResetLookAtPlayerGoal;
import de.markusbordihn.easynpc.entity.easynpc.ai.goal.ZombieAttackGoal;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1344;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1368;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1378;
import net.minecraft.class_1384;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1429;
import net.minecraft.class_1548;
import net.minecraft.class_1569;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import net.minecraft.class_3988;
import net.minecraft.class_4255;
import net.minecraft.class_4291;
import net.minecraft.class_5274;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ObjectiveUtils {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    private ObjectiveUtils() {
    }

    public static class_1352 createObjectiveGoal(ObjectiveDataEntry objectiveDataEntry, EasyNPC<?> easyNPC) {
        class_1297 targetOwner = objectiveDataEntry.getTargetOwner(easyNPC);
        class_1314 pathfinderMob = easyNPC.getPathfinderMob();
        switch (objectiveDataEntry.getType()) {
            case FOLLOW_PLAYER: {
                class_3222 targetServerPlayer = objectiveDataEntry.getTargetPlayer();
                if (targetServerPlayer != null && !targetServerPlayer.method_31481()) {
                    return new FollowLivingEntityGoal(easyNPC, (class_1309)targetServerPlayer, objectiveDataEntry.getSpeedModifier(), objectiveDataEntry.getStopDistance(), objectiveDataEntry.getStartDistance());
                }
                log.debug("Unable to find valid player {} for {}!", (Object)objectiveDataEntry.getTargetPlayer(), (Object)objectiveDataEntry);
                break;
            }
            case FOLLOW_OWNER: {
                class_1309 livingEntity;
                if (targetOwner instanceof class_1309 && !(livingEntity = (class_1309)targetOwner).method_31481()) {
                    return new FollowLivingEntityGoal(easyNPC, livingEntity, objectiveDataEntry.getSpeedModifier(), objectiveDataEntry.getStopDistance(), objectiveDataEntry.getStartDistance());
                }
                log.debug("Unable to find valid owner {} for {} with {}!", (Object)targetOwner, (Object)easyNPC.getEntity(), (Object)objectiveDataEntry);
                break;
            }
            case FOLLOW_ENTITY_BY_UUID: {
                class_1309 targetEntityMob = objectiveDataEntry.getTargetEntity(easyNPC);
                if (targetEntityMob != null && !targetEntityMob.method_31481()) {
                    return new FollowLivingEntityGoal(easyNPC, targetEntityMob, objectiveDataEntry.getSpeedModifier(), objectiveDataEntry.getStopDistance(), objectiveDataEntry.getStartDistance());
                }
                log.debug("Unable to find living entity {} for {}!", (Object)objectiveDataEntry.getTargetEntityUUID(), (Object)objectiveDataEntry);
                break;
            }
            case RANDOM_STROLL: {
                return new RandomStrollAroundGoal(easyNPC, objectiveDataEntry.getSpeedModifier());
            }
            case WATER_AVOIDING_RANDOM_STROLL: {
                return new class_1394(pathfinderMob, objectiveDataEntry.getSpeedModifier());
            }
            case MOVE_THROUGH_VILLAGE: {
                return new class_1368(pathfinderMob, objectiveDataEntry.getSpeedModifier(), objectiveDataEntry.getOnlyAtNight(), objectiveDataEntry.getDistanceToPoi(), objectiveDataEntry.getCanDealWithDoors());
            }
            case MOVE_BACK_TO_HOME: {
                return new MoveBackToHomeGoal(easyNPC, objectiveDataEntry.getSpeedModifier(), objectiveDataEntry.getStopDistance());
            }
            case MOVE_BACK_TO_VILLAGE: {
                return new class_4291(pathfinderMob, objectiveDataEntry.getSpeedModifier(), false);
            }
            case RANDOM_STROLL_AROUND_HOME: {
                return new RandomStrollAroundHomeGoal(easyNPC, objectiveDataEntry.getSpeedModifier());
            }
            case RANDOM_STROLL_IN_VILLAGE: {
                return new class_5274(pathfinderMob, objectiveDataEntry.getSpeedModifier());
            }
            case CROSSBOW_ATTACK: {
                return new CrossbowAttackGoal(easyNPC, objectiveDataEntry.getSpeedModifier(), objectiveDataEntry.getAttackRadius());
            }
            case BOW_ATTACK: {
                return new BowAttackGoal(easyNPC, objectiveDataEntry.getSpeedModifier(), objectiveDataEntry.getAttackInterval(), objectiveDataEntry.getAttackRadius());
            }
            case MELEE_ATTACK: {
                return new CustomMeleeAttackGoal(easyNPC, objectiveDataEntry.getSpeedModifier(), objectiveDataEntry.isMustSeeTarget());
            }
            case ZOMBIE_ATTACK: {
                return new ZombieAttackGoal(easyNPC, objectiveDataEntry.getSpeedModifier(), objectiveDataEntry.isMustSeeTarget());
            }
            case GUN_ATTACK: {
                return new GunAttackGoal(easyNPC, objectiveDataEntry.getSpeedModifier(), objectiveDataEntry.getAttackInterval(), objectiveDataEntry.getAttackRadius());
            }
            case RANDOM_SWIMMING: {
                return new class_1378(pathfinderMob, objectiveDataEntry.getSpeedModifier(), objectiveDataEntry.getInterval());
            }
            case FLOAT: {
                return new class_1347((class_1308)pathfinderMob);
            }
            case OPEN_DOOR: {
                return new class_4255((class_1308)pathfinderMob, false);
            }
            case CLOSE_DOOR: {
                return new class_4255((class_1308)pathfinderMob, true);
            }
            case LOOK_AT_RESET: {
                return new ResetLookAtPlayerGoal(easyNPC);
            }
            case LOOK_AT_PLAYER: {
                return new CustomLookAtPlayerGoal(easyNPC, class_1657.class, objectiveDataEntry.getLookDistance(), objectiveDataEntry.getProbability());
            }
            case LOOK_AT_MOB: {
                return new CustomLookAtPlayerGoal(easyNPC, class_1308.class, objectiveDataEntry.getLookDistance(), objectiveDataEntry.getProbability());
            }
            case LOOK_AT_ANIMAL: {
                return new CustomLookAtPlayerGoal(easyNPC, class_1429.class, objectiveDataEntry.getLookDistance(), objectiveDataEntry.getProbability());
            }
            case LOOK_RANDOM_AROUND: {
                return new class_1376((class_1308)pathfinderMob);
            }
            case PANIC: {
                return new class_1374(pathfinderMob, objectiveDataEntry.getSpeedModifier());
            }
            case AVOID_SUN: {
                return new class_1384(pathfinderMob);
            }
            case FLEE_SUN: {
                return new class_1344(pathfinderMob, objectiveDataEntry.getSpeedModifier());
            }
            default: {
                return null;
            }
        }
        return null;
    }

    public static class_1352 createObjectiveTarget(ObjectiveDataEntry objectiveDataEntry, EasyNPC<?> easyNPC) {
        class_1314 pathfinderMob = easyNPC.getPathfinderMob();
        return switch (objectiveDataEntry.getType()) {
            case ObjectiveType.ATTACK_ANIMAL -> new class_1400((class_1308)pathfinderMob, class_1429.class, objectiveDataEntry.isMustSeeTarget());
            case ObjectiveType.ATTACK_PLAYER -> new class_1400((class_1308)pathfinderMob, class_1657.class, objectiveDataEntry.isMustSeeTarget());
            case ObjectiveType.ATTACK_PLAYER_WITHOUT_OWNER -> new class_1400((class_1308)pathfinderMob, class_1657.class, objectiveDataEntry.getInterval(), objectiveDataEntry.isMustSeeTarget(), objectiveDataEntry.isMustReachTarget(), entity -> easyNPC.getEasyNPCOwnerData() != null && entity != easyNPC.getEasyNPCOwnerData().method_35057());
            case ObjectiveType.ATTACK_MONSTER -> new class_1400((class_1308)pathfinderMob, class_1588.class, objectiveDataEntry.isMustSeeTarget());
            case ObjectiveType.ATTACK_MOB_WITHOUT_CREEPER -> new class_1400((class_1308)pathfinderMob, class_1308.class, objectiveDataEntry.getInterval(), objectiveDataEntry.isMustSeeTarget(), objectiveDataEntry.isMustReachTarget(), entity -> entity instanceof class_1569 && !(entity instanceof class_1548));
            case ObjectiveType.ATTACK_MOB -> new class_1400((class_1308)pathfinderMob, class_1308.class, objectiveDataEntry.getInterval(), objectiveDataEntry.isMustSeeTarget(), objectiveDataEntry.isMustReachTarget(), class_1569.class::isInstance);
            case ObjectiveType.ATTACK_VILLAGER -> new class_1400((class_1308)pathfinderMob, class_3988.class, objectiveDataEntry.isMustSeeTarget());
            case ObjectiveType.OWNER_HURT_BY_TARGET -> new CustomOwnerHurtByTargetGoal(easyNPC);
            case ObjectiveType.HURT_BY_TARGET -> {
                class_1399 hurtByTargetGoal = new class_1399(pathfinderMob, new Class[0]);
                hurtByTargetGoal.method_6318(new Class[0]);
                yield hurtByTargetGoal;
            }
            default -> null;
        };
    }
}

