/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity;

import de.markusbordihn.easynpc.entity.ModEntityTypeProvider;
import de.markusbordihn.easynpc.entity.NPCEntityFactory;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UserDefinedEntityType
implements ModEntityTypeProvider {
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private final String entityId;
    private final class_1299<?> baseEntityType;
    private final class_1299.class_1300<? extends class_1297> entityBuilder;
    private final class_5321<class_1299<?>> resourceKey;

    public UserDefinedEntityType(String entityId, class_1299<?> baseEntityType, float width, float height) {
        this.entityId = entityId;
        this.baseEntityType = baseEntityType;
        this.entityBuilder = this.createEntityBuilder(width, height);
        this.resourceKey = this.createResourceKey(entityId);
    }

    @Override
    public String getId() {
        return this.entityId;
    }

    @Override
    public class_1299.class_1300<? extends class_1297> getBuilder() {
        return this.entityBuilder;
    }

    @Override
    public class_5321<class_1299<?>> getResourceKey() {
        return this.resourceKey;
    }

    public class_1299<?> getBaseEntityType() {
        return this.baseEntityType;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof UserDefinedEntityType)) {
            return false;
        }
        UserDefinedEntityType that = (UserDefinedEntityType)other;
        return this.entityId.equals(that.entityId);
    }

    public int hashCode() {
        return this.entityId.hashCode();
    }

    public String toString() {
        return "UserDefinedEntityType{entityId='" + this.entityId + "', baseEntityType='" + String.valueOf(this.baseEntityType) + "'}";
    }

    private class_1299.class_1300<? extends class_1297> createEntityBuilder(float width, float height) {
        return class_1299.class_1300.method_5903((entityType, level) -> {
            try {
                return NPCEntityFactory.createEntityFromBaseType(this.baseEntityType, entityType, level);
            }
            catch (Exception e) {
                log.error("Failed to create entity of type {} based on {}: {}", (Object)this.entityId, this.baseEntityType, (Object)e.getMessage(), (Object)e);
                return null;
            }
        }, (class_1311)class_1311.field_17715).method_17687(width, height).method_27299(12);
    }

    private class_5321<class_1299<?>> createResourceKey(String entityId) {
        return class_5321.method_29179((class_5321)class_7924.field_41266, (class_2960)new class_2960("easy_npc_custom", entityId));
    }
}

