/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.utils.TextUtils;
import java.util.EnumMap;
import java.util.Locale;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1314;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3852;
import net.minecraft.class_3854;
import net.minecraft.class_7923;

public interface VariantDataCapable<T extends class_1314>
extends EasyNPC<T> {
    public static final String EASY_NPC_DATA_VARIANT_TYPE_TAG = "VariantType";

    public static void registerSyncedVariantData(EnumMap<SynchedDataIndex, class_2940<?>> map, Class<? extends class_1297> entityClass) {
        log.info("- Registering Synched Variant Type Data for {}.", (Object)entityClass.getSimpleName());
        map.put(SynchedDataIndex.VARIANT_TYPE, class_2945.method_12791(entityClass, (class_2941)class_2943.field_13326));
    }

    default public Enum<?> getDefaultVariantType() {
        return VariantType.STEVE;
    }

    default public Enum<?> getVariantType() {
        return this.getVariantType((String)this.getSynchedEntityData(SynchedDataIndex.VARIANT_TYPE));
    }

    default public void setVariantType(Enum<?> variant) {
        this.setSynchedEntityData(SynchedDataIndex.VARIANT_TYPE, variant != null ? variant.name() : "");
        this.handleVariantTypeChange(variant);
    }

    default public void setVariantType(String name) {
        Enum<?> variantType = this.getVariantType(name);
        if (variantType != null) {
            this.setVariantType(variantType);
        } else {
            log.error("Unknown variant {} for {}", (Object)name, (Object)this);
        }
    }

    default public void handleVariantTypeChange(Enum<?> variant) {
    }

    default public Enum<?> getVariantType(String name) {
        return VariantType.valueOf(name);
    }

    default public Enum<?>[] getVariantTypes() {
        return VariantType.values();
    }

    default public Stream<String> getVariantTypeNames() {
        return Stream.of(this.getVariantTypes()).map(Enum::name);
    }

    default public class_2561 getVariantTypeName() {
        Enum<?> variant = this.getVariantType();
        return variant != null ? TextUtils.normalizeName(variant.name()) : this.getEntityTypeName();
    }

    default public boolean hasVariantTypeCrossedArms() {
        return this.hasVariantTypeCrossedArms(this.getVariantType());
    }

    default public boolean hasVariantTypeCrossedArms(Enum<?> variant) {
        return variant != null && variant.name().endsWith("_CROSSED_ARMS");
    }

    default public boolean hasVariantTypeSaddled() {
        return this.hasVariantTypeSaddled(this.getVariantType());
    }

    default public boolean hasVariantTypeSaddled(Enum<?> variant) {
        return variant != null && variant.name().endsWith("_SADDLED");
    }

    default public class_3852 getVillagerProfession(Enum<?> variantType) {
        String name = variantType.name().toLowerCase(Locale.ROOT);
        for (class_3852 profession : class_7923.field_41195) {
            if (!name.endsWith(profession.comp_818().toLowerCase(Locale.ROOT))) continue;
            return profession;
        }
        return null;
    }

    default public class_3854 getVillagerType(Enum<?> variantType) {
        String name = variantType.name().toLowerCase(Locale.ROOT);
        for (class_3854 villagerType : class_7923.field_41194) {
            if (!name.startsWith(villagerType.toString().toLowerCase(Locale.ROOT))) continue;
            return villagerType;
        }
        return null;
    }

    default public void defineSynchedVariantData() {
        this.defineSynchedEntityData(SynchedDataIndex.VARIANT_TYPE, this.getDefaultVariantType().name());
    }

    default public void addAdditionalVariantData(class_2487 compoundTag) {
        if (this.getVariantType() != null) {
            compoundTag.method_10582(EASY_NPC_DATA_VARIANT_TYPE_TAG, this.getVariantType().name());
        }
    }

    default public void readAdditionalVariantData(class_2487 compoundTag) {
        String variantType;
        if (compoundTag.method_10545(EASY_NPC_DATA_VARIANT_TYPE_TAG) && !(variantType = compoundTag.method_10558(EASY_NPC_DATA_VARIANT_TYPE_TAG)).isEmpty()) {
            this.setVariantType(this.getVariantType(variantType));
        }
    }

    public static enum VariantType {
        STEVE,
        ALEX;

    }
}

