/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.npc.raw;

import de.markusbordihn.easynpc.data.configuration.ConfigurationData;
import de.markusbordihn.easynpc.data.model.ModelPartType;
import de.markusbordihn.easynpc.data.model.ModelType;
import de.markusbordihn.easynpc.data.scale.CustomScale;
import de.markusbordihn.easynpc.data.server.ServerEntityData;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.data.status.StatusDataType;
import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.data.synched.SynchedEntityData;
import de.markusbordihn.easynpc.data.ticker.TickerType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPCBase;
import de.markusbordihn.easynpc.entity.easynpc.handlers.AttackHandler;
import de.markusbordihn.easynpc.entity.easynpc.handlers.InteractionHandler;
import de.markusbordihn.easynpc.entity.easynpc.handlers.VisibilityHandler;
import de.markusbordihn.easynpc.handler.AttributeHandler;
import de.markusbordihn.easynpc.server.player.FakePlayer;
import de.markusbordihn.easynpc.utils.TextUtils;
import java.util.EnumMap;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1355;
import net.minecraft.class_1657;
import net.minecraft.class_1811;
import net.minecraft.class_1914;
import net.minecraft.class_1916;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4802;
import net.minecraft.class_5425;
import net.minecraft.class_6019;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HumanoidRaw
extends class_1314
implements EasyNPCBase<class_1314> {
    public static final String ID = "humanoid_raw";
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    protected static final EnumMap<SynchedDataIndex, class_2940<?>> entityDataAccessorMap = new EnumMap(SynchedDataIndex.class);
    private static final class_6019 PERSISTENT_ANGER_TIME = class_4802.method_24505((int)20, (int)39);
    private final EnumMap<TickerType, Integer> tickerMap = new EnumMap(TickerType.class);
    private final EnumMap<StatusDataType, Boolean> statusDataFlagMap = new EnumMap(StatusDataType.class);
    protected class_1916 merchantTradingOffers;
    private ServerEntityData serverEntityData;
    private int attackAnimationTick;
    private int npcDataVersion = -1;
    private UUID persistentAngerTarget;
    private int remainingPersistentAngerTime;
    private SynchedEntityData synchedEntityData;
    private class_1657 tradingPlayer;
    private FakePlayer fakePlayer;

    public HumanoidRaw(class_1299<? extends class_1314> entityType, class_1937 level, Enum<?> variant) {
        super(entityType, level);
        this.registerEasyNPCDefaultVariant(variant);
    }

    public HumanoidRaw(class_1299<? extends class_1314> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Override
    public FakePlayer getFakePlayer(class_3218 level, class_2338 blockPos) {
        if (FakePlayer.isInvalidFakePlayer(this.fakePlayer)) {
            this.fakePlayer = new FakePlayer(level, blockPos);
            return this.fakePlayer;
        }
        return this.fakePlayer.updatePosition(level, blockPos);
    }

    @Override
    public int getTicker(TickerType tickerType) {
        return this.tickerMap.getOrDefault((Object)tickerType, 0);
    }

    @Override
    public void setTicker(TickerType tickerType, int ticker) {
        this.tickerMap.put(tickerType, ticker);
    }

    @Override
    public EnumMap<StatusDataType, Boolean> getStatusDataFlags() {
        return this.statusDataFlagMap;
    }

    public void method_24651() {
        this.field_6278 = 0;
    }

    @Override
    public int method_6501() {
        return this.attackAnimationTick;
    }

    public boolean method_6121(class_1297 entity) {
        this.attackAnimationTick = 10;
        this.method_37908().method_8421((class_1297)this, (byte)4);
        return super.method_6121(entity);
    }

    public void method_5711(byte flag) {
        super.method_5711(flag);
        if (flag == 4) {
            this.attackAnimationTick = 10;
        }
    }

    public void method_6007() {
        super.method_6007();
        if (this.isClientSideInstance()) {
            this.method_6119();
            if (this.attackAnimationTick > 0) {
                --this.attackAnimationTick;
            }
        } else {
            this.method_29510((class_3218)this.method_37908(), true);
        }
    }

    public class_2561 method_5477() {
        class_2561 component = this.method_5797();
        return component != null ? TextUtils.removeAction(component) : this.method_23315();
    }

    public boolean method_5643(class_1282 damageSource, float damage) {
        this.handleHurtEvent(damageSource, damage);
        return super.method_5643(damageSource, damage);
    }

    public void method_6078(class_1282 damageSource) {
        this.handleDieEvent(damageSource);
        super.method_6078(damageSource);
    }

    public class_1297 method_5731(class_3218 serverLevel) {
        this.handleChangeDimensionEvent(serverLevel);
        return super.method_5731(serverLevel);
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        return InteractionHandler.handleMobInteraction(this, player, hand);
    }

    public boolean method_38069() {
        return this.isClientSideInstance();
    }

    public boolean method_5767() {
        return VisibilityHandler.handleIsInvisible(this, super.method_5767());
    }

    public boolean method_5756(class_1657 player) {
        return VisibilityHandler.handleIsInvisibleToPlayer(this, player, super.method_5756(player));
    }

    @Override
    public class_1657 method_8257() {
        return this.tradingPlayer;
    }

    @Override
    public void method_8259(class_1657 player) {
        this.tradingPlayer = player;
    }

    @Override
    public class_1916 getMerchantTradingOffers() {
        return this.merchantTradingOffers;
    }

    @Override
    public void setMerchantTradingOffers(class_1916 merchantOffers) {
        this.merchantTradingOffers = merchantOffers;
    }

    @Override
    public void method_18008(class_1914 merchantOffer) {
        this.rewardMerchantTradeXp(merchantOffer);
    }

    @Override
    public void method_19181() {
        this.stopMerchantTrading();
    }

    @Override
    public int getNPCDataVersion() {
        return this.npcDataVersion;
    }

    @Override
    public void setNPCDataVersion(int version) {
        this.npcDataVersion = version;
    }

    public class_1315 method_5943(class_5425 serverLevelAccessor, class_1266 difficulty, class_3730 mobSpawnType, class_1315 spawnGroupData, class_2487 compoundTag) {
        AttributeHandler.handleDefaultAttributes(this);
        return this.finalizeEasyNPCSpawn(super.method_5943(serverLevelAccessor, difficulty, mobSpawnType, spawnGroupData, compoundTag));
    }

    @Override
    public void handleEasyNPCJoinEvent(EasyNPC<?> easyNPC) {
        this.onEasyNPCJoinUpdateObjective(easyNPC);
    }

    @Override
    public void handleEasyNPCLeaveEvent(EasyNPC<?> easyNPC) {
        this.onEasyNPCLeaveUpdateObjective(easyNPC);
    }

    @Override
    public void handlePlayerJoinEvent(class_3222 serverPlayer) {
        this.onPlayerJoinUpdateObjective(serverPlayer);
    }

    @Override
    public void handlePlayerLeaveEvent(class_3222 serverPlayer) {
        this.onPlayerLeaveUpdateObjective(serverPlayer);
    }

    @Override
    public void handleLivingEntityJoinEvent(class_1309 livingEntity) {
        this.onLivingEntityJoinUpdateObjective(livingEntity);
    }

    @Override
    public void handleLivingEntityLeaveEvent(class_1309 livingEntity) {
        this.onLivingEntityLeaveUpdateObjective(livingEntity);
    }

    public boolean method_25938(class_1811 projectileWeaponItem) {
        return AttackHandler.canFireProjectileWeapon(projectileWeaponItem);
    }

    public int method_29507() {
        return this.remainingPersistentAngerTime;
    }

    public void method_29514(int remainingPersistentAngerTime) {
        this.remainingPersistentAngerTime = remainingPersistentAngerTime;
    }

    public UUID method_29508() {
        return this.persistentAngerTarget;
    }

    public void method_29513(UUID targetUUID) {
        this.persistentAngerTarget = targetUUID;
    }

    public void method_29509() {
        this.method_29514(PERSISTENT_ANGER_TIME.method_35008(this.field_5974));
    }

    @Override
    public class_1355 getEntityGoalSelector() {
        return this.field_6201;
    }

    @Override
    public class_1355 getEntityTargetSelector() {
        return this.field_6185;
    }

    @Override
    public <T> void defineSynchedEntityData(SynchedDataIndex synchedDataIndex, T defaultData) {
        if (this.synchedEntityData == null) {
            this.synchedEntityData = new SynchedEntityData((class_1297)this, entityDataAccessorMap);
        }
        this.synchedEntityData.define(synchedDataIndex, defaultData);
    }

    @Override
    public <T> void setSynchedEntityData(SynchedDataIndex synchedDataIndex, T data, boolean forceUpdate) {
        this.synchedEntityData.set(synchedDataIndex, data, forceUpdate);
    }

    @Override
    public <T> T getSynchedEntityData(SynchedDataIndex synchedDataIndex) {
        return this.synchedEntityData.get(synchedDataIndex);
    }

    @Override
    public void defineServerEntityData() {
        this.serverEntityData = new ServerEntityData((class_1297)this);
    }

    @Override
    public ServerEntityData getServerEntityData() {
        if (this.serverEntityData == null) {
            this.defineServerEntityData();
        }
        return this.serverEntityData;
    }

    public boolean method_5931(class_1657 player) {
        class_3222 serverPlayer;
        if (!this.method_5934() && player instanceof class_3222 && ((serverPlayer = (class_3222)player).method_7337() || this.isNPCOwner(serverPlayer))) {
            return true;
        }
        return !this.method_5934() && this.getEntityAttributes().getInteractionAttributes().canBeLeashed();
    }

    public boolean method_6094() {
        return this.getEntityAttributes().getEnvironmentalAttributes().canBreatheUnderwater();
    }

    public boolean method_5732() {
        return this.getEntityAttributes().getCombatAttributes().isAttackableByPlayers();
    }

    public boolean method_5810() {
        return this.getEntityAttributes().getInteractionAttributes().isPushable();
    }

    public boolean method_49108() {
        return this.getEntityAttributes().getInteractionAttributes().canBeHitByProjectile() && this.method_5805();
    }

    protected void method_6070() {
        if (this.getEntityAttributes().getInteractionAttributes().pushEntities()) {
            super.method_6070();
        }
    }

    public boolean method_5655() {
        return this.getEntityAttributes().getCombatAttributes().isInvulnerable();
    }

    public boolean method_5679(class_1282 damageSource) {
        return AttackHandler.handleIsInvulnerableTo(this, damageSource, super.method_5679(damageSource));
    }

    public void method_5966() {
        this.playDefaultAmbientSound();
    }

    public int method_5970() {
        return 240;
    }

    public void method_6013(class_1282 damageSource) {
        this.playDefaultHurtSound(damageSource);
    }

    protected void method_5712(class_2338 blockPos, class_2680 blockState) {
        this.playDefaultStepSound(blockPos, blockState);
    }

    public class_3414 method_6002() {
        return this.getDefaultDeathSound();
    }

    protected void method_18379() {
        if (this.getEntityAttributes().getMovementAttributes().canUseNetherPortal()) {
            super.method_18379();
        }
    }

    protected boolean method_23734() {
        return false;
    }

    public boolean method_5974(double distance) {
        return false;
    }

    public void method_5670() {
        super.method_5670();
        if (this.isClientSideInstance() || !this.method_5805()) {
            return;
        }
        this.handleCustomObjectiveBaseTick();
        this.handleBaseTick();
    }

    public void method_6091(class_243 vec3) {
        this.handleNavigationTravelEvent(vec3);
        super.method_6091(vec3);
    }

    public boolean method_6765() {
        return false;
    }

    public void method_6576(class_3419 soundSource) {
        if (soundSource != null) {
            this.method_37908().method_43129(null, (class_1297)this, class_3417.field_14824, soundSource, 0.5f, 1.0f);
        }
    }

    public boolean method_6725() {
        return false;
    }

    public class_1310 method_6046() {
        return class_1310.field_6290;
    }

    @Override
    public ConfigurationData getConfigurationData() {
        return ConfigurationData.RAW;
    }

    @Override
    public SkinModel getSkinModel() {
        return SkinModel.HUMANOID;
    }

    @Override
    public Enum<?>[] getVariantTypes() {
        return VariantType.values();
    }

    @Override
    public Enum<?> getDefaultVariantType() {
        return VariantType.STEVE;
    }

    @Override
    public ModelType getModelType() {
        return ModelType.HUMANOID;
    }

    @Override
    public Enum<?> getVariantType(String name) {
        try {
            return VariantType.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            return this.getDefaultVariantType();
        }
    }

    protected void method_5693() {
        super.method_5693();
        this.defineEasyNPCBaseSyncedData();
        this.defineEasyNPCBaseServerSideData();
    }

    public void method_5652(class_2487 compoundTag) {
        super.method_5652(compoundTag);
        this.method_29517(compoundTag);
        this.addEasyNPCBaseAdditionalSaveData(compoundTag);
    }

    public void method_5749(class_2487 compoundTag) {
        super.method_5749(compoundTag);
        this.method_29512(this.method_37908(), compoundTag);
        this.readEasyNPCBaseAdditionalSaveData(compoundTag);
    }

    public class_4048 method_18377(class_4050 pose) {
        CustomScale rootScale = this.getModelPartScale(ModelPartType.ROOT);
        if (rootScale.x() != 1.0f || rootScale.y() != 1.0f) {
            class_4048 baseDimensions = super.method_18377(pose);
            return baseDimensions.method_19539(rootScale.x(), rootScale.y());
        }
        return super.method_18377(pose);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof EasyNPCBase)) {
            return false;
        }
        EasyNPCBase easyNPCBase = (EasyNPCBase)object;
        return Objects.equals(this.method_5667(), easyNPCBase.getEntityUUID());
    }

    public int hashCode() {
        return Objects.hash(this.method_5667());
    }

    public boolean method_5807() {
        return VisibilityHandler.handleIsCustomNameVisible(this, super.method_5807());
    }

    static {
        EasyNPCBase.registerEasyNPCSyncedData(entityDataAccessorMap, HumanoidRaw.class);
    }

    public static enum VariantType {
        STEVE,
        ALEX,
        ARI,
        EFE,
        KAI,
        MAKENA,
        NOOR,
        SUNNY,
        ZURI;

    }
}

