/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.components;

import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.client.screen.components.CustomButton;
import de.markusbordihn.easynpc.network.components.TextComponent;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class SpriteButton
extends CustomButton {
    public static final int DEFAULT_HEIGHT = 16;
    public static final ResourceLocation DEFAULT_SPRITE = Constants.TEXTURE_CONFIGURATION;
    private final ResourceLocation sprite;
    private final int spriteX;
    private final int spriteY;
    private final int spriteOffsetX;
    private final int spriteOffsetY;
    private final int spriteWidth;
    private final int spriteHeight;
    private boolean renderBackground = true;
    private boolean renderCenter = true;

    public SpriteButton(int left, int top, int width, ResourceLocation sprite, int spriteX, int spriteY, int spriteOffsetX, int spriteOffsetY, int spriteWidth, int spriteHeight, Button.OnPress onPress) {
        this(left, top, width, 16, sprite, spriteX, spriteY, spriteOffsetX, spriteOffsetY, spriteWidth, spriteHeight, onPress);
    }

    public SpriteButton(int left, int top, int width, int height, ResourceLocation sprite, int spriteX, int spriteY, int spriteOffsetX, int spriteOffsetY, int spriteWidth, int spriteHeight, Button.OnPress onPress) {
        this(left, top, width, height, (Component)TextComponent.getBlankText(), sprite, spriteX, spriteY, spriteOffsetX, spriteOffsetY, spriteWidth, spriteHeight, onPress);
    }

    public SpriteButton(int left, int top, int width, int height, int spriteX, int spriteY, int spriteOffsetX, int spriteOffsetY, int spriteWidth, int spriteHeight, Button.OnPress onPress) {
        this(left, top, width, height, (Component)TextComponent.getBlankText(), DEFAULT_SPRITE, spriteX, spriteY, spriteOffsetX, spriteOffsetY, spriteWidth, spriteHeight, onPress);
    }

    public SpriteButton(int left, int top, int width, int height, ResourceLocation sprite, int spriteOffsetX, int spriteOffsetY, int spriteWidth, int spriteHeight, Button.OnPress onPress) {
        this(left, top, width, height, "", sprite, 0, 0, spriteOffsetX, spriteOffsetY, spriteWidth, spriteHeight, onPress);
    }

    public SpriteButton(int left, int top, int width, int height, String label, int spriteX, int spriteY, int spriteOffsetX, int spriteOffsetY, int spriteWidth, int spriteHeight, Button.OnPress onPress) {
        this(left, top, width, height, (Component)TextComponent.getTextComponent(label), DEFAULT_SPRITE, spriteX, spriteY, spriteOffsetX, spriteOffsetY, spriteWidth, spriteHeight, onPress);
    }

    public SpriteButton(int left, int top, int width, int height, String label, ResourceLocation sprite, int spriteX, int spriteY, int spriteOffsetX, int spriteOffsetY, int spriteWidth, int spriteHeight, Button.OnPress onPress) {
        this(left, top, width, height, (Component)TextComponent.getTextComponent(label), sprite, spriteX, spriteY, spriteOffsetX, spriteOffsetY, spriteWidth, spriteHeight, onPress);
    }

    public SpriteButton(int left, int top, int width, int height, Component component, ResourceLocation sprite, int spriteX, int spriteY, int spriteOffsetX, int spriteOffsetY, int spriteWidth, int spriteHeight, Button.OnPress onPress) {
        super(left, top, width, height, component, onPress);
        this.sprite = sprite;
        this.spriteX = spriteX;
        this.spriteY = spriteY;
        this.spriteOffsetX = spriteOffsetX;
        this.spriteOffsetY = spriteOffsetY;
        this.spriteWidth = spriteWidth;
        this.spriteHeight = spriteHeight;
    }

    @Override
    public void renderButtonText(GuiGraphics guiGraphics, Font font, Component component, int x, int y) {
        if (component != null && !component.getString().isEmpty()) {
            int fgColor = this.active ? 0xFFFFFF : 0xA0A0A0;
            int textColor = fgColor | Mth.ceil((float)(this.alpha * 255.0f)) << 24;
            if (this.renderCenter) {
                guiGraphics.drawCenteredString(font, component, this.getX() + (this.width + this.spriteWidth) / 2, this.getY() + (this.height - 8) / 2, textColor);
            } else {
                guiGraphics.drawString(font, component, this.getX() + this.spriteWidth + 4, this.getY() + (this.height - 8) / 2, textColor, false);
            }
        }
    }

    public void setRenderBackground(boolean renderBackground) {
        this.renderBackground = renderBackground;
    }

    public SpriteButton setRenderCenter(boolean renderCenter) {
        this.renderCenter = renderCenter;
        return this;
    }

    @Override
    public void renderButton(GuiGraphics guiGraphics, int left, int top, float partialTicks) {
        if (this.renderBackground) {
            super.renderButton(guiGraphics, left, top, partialTicks);
        }
        guiGraphics.blit(RenderType::guiTextured, this.sprite, this.getX() + this.spriteX, this.getY() + this.spriteY, (float)this.spriteOffsetX, this.isActive() ? (float)this.spriteOffsetY : (float)(this.spriteOffsetY + this.spriteHeight), this.spriteWidth, this.spriteHeight, 256, 256);
    }
}

