/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.ai.goal;

import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.NavigationDataCapable;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.phys.Vec3;

public class RandomStrollAroundGoal<T extends EasyNPC<?>>
extends RandomStrollGoal {
    private final NavigationDataCapable<?> navigationData;

    public RandomStrollAroundGoal(T easyNPCEntity, double speedModifier) {
        this(easyNPCEntity, speedModifier, 120);
    }

    public RandomStrollAroundGoal(T easyNPCEntity, double speedModifier, int interval) {
        super(easyNPCEntity.getPathfinderMob(), speedModifier, interval);
        this.navigationData = easyNPCEntity.getEasyNPCNavigationData();
    }

    public boolean canContinueToUse() {
        return !this.mob.getNavigation().isDone() && !this.mob.isVehicle() && (!this.mob.isAggressive() || this.mob.getTarget() == null);
    }

    protected Vec3 getPosition() {
        if (this.navigationData.canFly()) {
            Vec3 vec3 = this.mob.getViewVector(0.0f);
            Vec3 randomHoverPos = HoverRandomPos.getPos((PathfinderMob)this.mob, (int)8, (int)7, (double)vec3.x, (double)vec3.z, (float)1.5707964f, (int)3, (int)1);
            return randomHoverPos != null ? randomHoverPos : AirAndWaterRandomPos.getPos((PathfinderMob)this.mob, (int)8, (int)4, (int)-2, (double)vec3.x, (double)vec3.z, (double)1.5707963705062866);
        }
        return DefaultRandomPos.getPos((PathfinderMob)this.mob, (int)10, (int)7);
    }
}

