/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.synched;

import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import java.util.Map;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class SynchedEntityData {
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private final Entity entity;
    private final Class<? extends Entity> entityClass;
    private final Map<SynchedDataIndex, EntityDataAccessor<?>> entityDataAccessorMap;

    public SynchedEntityData(Entity entity, Map<SynchedDataIndex, EntityDataAccessor<?>> entityDataAccessorMap) {
        this.entity = entity;
        this.entityClass = entity.getClass();
        this.entityDataAccessorMap = entityDataAccessorMap;
        log.debug("Initialized SynchedEntityData for {} ({}) with {}", (Object)entity, this.entityClass, this.entityDataAccessorMap);
    }

    public <T> void define(SynchedEntityData.Builder builder, SynchedDataIndex synchedDataIndex, T defaultData) {
        EntityDataAccessor<?> entityDataAccessor = this.entityDataAccessorMap.get((Object)synchedDataIndex);
        builder.define(entityDataAccessor, defaultData);
    }

    public <T> T get(SynchedDataIndex synchedDataIndex) {
        EntityDataAccessor<?> entityDataAccessor = this.entityDataAccessorMap.get((Object)synchedDataIndex);
        return (T)this.entity.getEntityData().get(entityDataAccessor);
    }

    public <T> void set(SynchedDataIndex synchedDataIndex, T data) {
        this.set(synchedDataIndex, data, false);
    }

    public <T> void set(SynchedDataIndex synchedDataIndex, T data, boolean forceUpdate) {
        EntityDataAccessor<?> entityDataAccessor = this.entityDataAccessorMap.get((Object)synchedDataIndex);
        this.entity.getEntityData().set(entityDataAccessor, data, forceUpdate);
    }
}

