/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity;

import de.markusbordihn.easynpc.compat.CompatConstants;
import de.markusbordihn.easynpc.compat.epicfight.entity.EpicFightZombie;
import de.markusbordihn.easynpc.entity.ModCustomEntityType;
import de.markusbordihn.easynpc.entity.ModNPCEntityType;
import de.markusbordihn.easynpc.entity.ModRawEntityType;
import de.markusbordihn.easynpc.entity.UserDefinedEntityRegistry;
import de.markusbordihn.easynpc.entity.UserDefinedEntityType;
import de.markusbordihn.easynpc.entity.VanillaEntityAttributeHelper;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class ModEntityType {
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.ENTITY_TYPE, (String)"easy_npc");
    public static final Map<ModRawEntityType, DeferredHolder<EntityType<?>, EntityType<?>>> RAW_TYPE = new EnumMap(ModRawEntityType.class);
    public static final Map<ModNPCEntityType, DeferredHolder<EntityType<?>, EntityType<?>>> NPC_TYPE = new EnumMap(ModNPCEntityType.class);
    public static final Map<ModCustomEntityType, DeferredHolder<EntityType<?>, EntityType<?>>> CUSTOM_TYPE = new EnumMap(ModCustomEntityType.class);
    public static final Map<UserDefinedEntityType, DeferredHolder<EntityType<?>, EntityType<?>>> USER_DEFINED_TYPE = new HashMap();
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    public static DeferredHolder<EntityType<?>, EntityType<EpicFightZombie>> EPIC_FIGHT_ZOMBIE;

    private ModEntityType() {
    }

    public static <T extends Entity> EntityType<T> getEntityType(ModRawEntityType type) {
        if (!RAW_TYPE.containsKey(type)) {
            throw new IllegalArgumentException("Invalid raw entity type '" + String.valueOf(type) + "'! Supported types are " + String.valueOf(RAW_TYPE.keySet()));
        }
        return (EntityType)RAW_TYPE.get(type).get();
    }

    public static <T extends Entity> EntityType<T> getEntityType(ModNPCEntityType type) {
        if (!NPC_TYPE.containsKey(type)) {
            throw new IllegalArgumentException("Invalid NPC entity type '" + String.valueOf(type) + "'! Supported types are " + String.valueOf(NPC_TYPE.keySet()));
        }
        return (EntityType)NPC_TYPE.get(type).get();
    }

    public static <T extends Entity> EntityType<T> getEntityType(ModCustomEntityType type) {
        if (!CUSTOM_TYPE.containsKey(type)) {
            throw new IllegalArgumentException("Invalid NPC entity type '" + String.valueOf(type) + "'! Supported types are " + String.valueOf(CUSTOM_TYPE.keySet()));
        }
        return (EntityType)CUSTOM_TYPE.get(type).get();
    }

    public static <T extends Entity> EntityType<T> getConfigurableEntityType(UserDefinedEntityType type) {
        if (!USER_DEFINED_TYPE.containsKey(type)) {
            throw new IllegalArgumentException("Invalid configured entity type '" + String.valueOf(type) + "'! Supported types are " + String.valueOf(USER_DEFINED_TYPE.keySet()));
        }
        return (EntityType)USER_DEFINED_TYPE.get(type).get();
    }

    @SubscribeEvent
    public static void entityAttributeCreation(EntityAttributeCreationEvent event) {
        for (ModRawEntityType modRawEntityType : ModRawEntityType.values()) {
            if (modRawEntityType.getAttributes() != null) {
                event.put((EntityType)RAW_TYPE.get(modRawEntityType).get(), modRawEntityType.getAttributes().build());
                continue;
            }
            log.warn("Raw entity type {} does not have attributes defined!", modRawEntityType.getResourceKey());
        }
        for (Enum enum_ : ModNPCEntityType.values()) {
            if (((ModNPCEntityType)enum_).getAttributes() != null) {
                event.put((EntityType)NPC_TYPE.get(enum_).get(), ((ModNPCEntityType)enum_).getAttributes().build());
                continue;
            }
            log.warn("NPC entity type {} does not have attributes defined!", ((ModNPCEntityType)enum_).getResourceKey());
        }
        for (Enum enum_ : ModCustomEntityType.values()) {
            if (((ModCustomEntityType)enum_).getAttributes() != null) {
                event.put((EntityType)CUSTOM_TYPE.get(enum_).get(), ((ModCustomEntityType)enum_).getAttributes().build());
                continue;
            }
            log.warn("Custom entity type {} does not have attributes defined!", ((ModCustomEntityType)enum_).getResourceKey());
        }
        for (Map.Entry entry : USER_DEFINED_TYPE.entrySet()) {
            UserDefinedEntityType type = (UserDefinedEntityType)entry.getKey();
            EntityType entityType = (EntityType)((DeferredHolder)entry.getValue()).get();
            EntityType<?> baseEntityType = type.getBaseEntityType();
            UserDefinedEntityRegistry.registerEntityType(type, entityType);
            try {
                AttributeSupplier.Builder vanillaAttributes;
                boolean attributesFound = false;
                for (ModRawEntityType modRawEntityType : ModRawEntityType.values()) {
                    if (RAW_TYPE.get(modRawEntityType).get() != baseEntityType || modRawEntityType.getAttributes() == null) continue;
                    event.put(entityType, modRawEntityType.getAttributes().build());
                    attributesFound = true;
                    log.debug("Used raw entity type {} attributes for user-defined entity {}", (Object)modRawEntityType.getId(), (Object)type.getId());
                    break;
                }
                if (!attributesFound) {
                    for (Enum enum_ : ModNPCEntityType.values()) {
                        if (NPC_TYPE.get(enum_).get() != baseEntityType || ((ModNPCEntityType)enum_).getAttributes() == null) continue;
                        event.put(entityType, ((ModNPCEntityType)enum_).getAttributes().build());
                        attributesFound = true;
                        log.debug("Used NPC entity type {} attributes for user-defined entity {}", (Object)((ModNPCEntityType)enum_).getId(), (Object)type.getId());
                        break;
                    }
                }
                if (!attributesFound) {
                    for (Enum enum_ : ModCustomEntityType.values()) {
                        if (CUSTOM_TYPE.get(enum_).get() != baseEntityType || ((ModCustomEntityType)enum_).getAttributes() == null) continue;
                        event.put(entityType, ((ModCustomEntityType)enum_).getAttributes().build());
                        attributesFound = true;
                        log.debug("Used custom entity type {} attributes for user-defined entity {}", (Object)((ModCustomEntityType)enum_).getId(), (Object)type.getId());
                        break;
                    }
                }
                if (!attributesFound && (vanillaAttributes = VanillaEntityAttributeHelper.getVanillaAttributesForEntityType(baseEntityType)) != null) {
                    event.put(entityType, vanillaAttributes.build());
                    attributesFound = true;
                    log.info("Used vanilla attributes for user-defined entity {} with base type {}", (Object)type.getId(), baseEntityType);
                }
                if (attributesFound) continue;
                log.error("No attributes found for user-defined entity {} with base type {} - this will cause crashes!", (Object)type.getId(), baseEntityType);
                event.put(entityType, LivingEntity.createLivingAttributes().build());
                log.warn("Using emergency fallback attributes for user-defined entity {}", (Object)type.getId());
            }
            catch (Exception e) {
                log.error("Failed to set attributes for user-defined entity {}: {}", (Object)type.getId(), (Object)e.getMessage(), (Object)e);
                try {
                    event.put(entityType, LivingEntity.createLivingAttributes().build());
                    log.warn("Applied emergency fallback attributes for user-defined entity {} due to error", (Object)type.getId());
                }
                catch (Exception fallbackError) {
                    log.error("Even emergency fallback failed for user-defined entity {}: {}", (Object)type.getId(), (Object)fallbackError.getMessage());
                }
            }
        }
        if (CompatConstants.MOD_EPIC_FIGHT_LOADED) {
            // empty if block
        }
    }

    private static /* synthetic */ EntityType lambda$static$2(ModCustomEntityType type) {
        return type.getBuilder().build(type.getResourceKey().toString());
    }

    private static /* synthetic */ EntityType lambda$static$1(ModNPCEntityType type) {
        return type.getBuilder().build(type.getResourceKey().toString());
    }

    static {
        for (ModRawEntityType modRawEntityType : ModRawEntityType.values()) {
            log.info("Registering raw entity type {}", modRawEntityType.getResourceKey());
            RAW_TYPE.put(modRawEntityType, ENTITY_TYPES.register(modRawEntityType.getId(), () -> modRawEntityType.getBuilder().build(modRawEntityType.getResourceKey().toString())));
        }
        for (Enum enum_ : ModNPCEntityType.values()) {
            log.info("Registering NPC entity type {}", ((ModNPCEntityType)enum_).getResourceKey());
            NPC_TYPE.put((ModNPCEntityType)enum_, ENTITY_TYPES.register(((ModNPCEntityType)enum_).getId(), () -> ModEntityType.lambda$static$1((ModNPCEntityType)enum_)));
        }
        for (Enum enum_ : ModCustomEntityType.values()) {
            log.info("Registering custom entity type {}", ((ModCustomEntityType)enum_).getResourceKey());
            CUSTOM_TYPE.put((ModCustomEntityType)enum_, ENTITY_TYPES.register(((ModCustomEntityType)enum_).getId(), () -> ModEntityType.lambda$static$2((ModCustomEntityType)enum_)));
        }
        UserDefinedEntityRegistry.initialize();
        for (UserDefinedEntityType type : UserDefinedEntityRegistry.getAvailableEntityTypes()) {
            log.info("Registering user-defined entity type {}", type.getResourceKey());
            DeferredHolder registryObject = ENTITY_TYPES.register(type.getId(), () -> type.getBuilder().build(type.getResourceKey().toString()));
            USER_DEFINED_TYPE.put(type, registryObject);
        }
        if (CompatConstants.MOD_EPIC_FIGHT_LOADED) {
            // empty if block
        }
    }
}

