/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.server.ServerDataAccessor;
import de.markusbordihn.easynpc.data.server.ServerDataIndex;
import de.markusbordihn.easynpc.data.server.ServerEntityData;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.network.syncher.EntityDataSerializersManager;
import de.markusbordihn.easynpc.utils.CompoundTagUtils;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;

public interface PresetDataCapable<T extends PathfinderMob>
extends EasyNPC<T> {
    public static final ServerDataAccessor<UUID> CUSTOM_DATA_PRESET_UUID = ServerEntityData.defineId(ServerDataIndex.PRESET_UUID, EntityDataSerializersManager.UUID);
    public static final String PRESET_UUID_TAG = "PresetUUID";
    public static final List<String> ENTITY_DATA_VOLATILE_FIELDS = List.of("AbsorptionAmount", "Air", "AngerTime", "DeathTime", "FallDistance", "FallFlying", "Fire", "forge:spawn_type", "HurtByTimestamp", "HurtTime", "Motion", "PortalCooldown");

    default public void importPresetData(CompoundTag compoundTag) {
        if (compoundTag == null || compoundTag.isEmpty() || this.getEntity() == null) {
            return;
        }
        if (this.getEntity() != null) {
            this.getEntity().setPose(Pose.STANDING);
        }
        if (this.getEasyNPCModelData() != null) {
            this.getEasyNPCModelData().setModelPose(ModelPose.DEFAULT);
        }
        if (this.getEasyNPCActionEventData() != null) {
            this.getEasyNPCActionEventData().clearActionEventSet();
        }
        if (this.getEasyNPCDialogData() != null) {
            this.getEasyNPCDialogData().clearDialogDataSet();
        }
        if (!compoundTag.contains("UUID") || !compoundTag.contains("Pos")) {
            CompoundTag existingCompoundTag = this.serializePresetData();
            if (existingCompoundTag.contains("DialogData")) {
                existingCompoundTag.remove("DialogData");
            }
            if (existingCompoundTag.contains("ModelData")) {
                existingCompoundTag.remove("ModelData");
            }
            if (existingCompoundTag.contains("SkinData")) {
                existingCompoundTag.remove("SkinData");
            }
            if (existingCompoundTag.contains("RenderData")) {
                existingCompoundTag.remove("RenderData");
            }
            if (existingCompoundTag.contains("ActionData")) {
                existingCompoundTag.remove("ActionData");
            }
            log.debug("Merging preset {} with existing data {} for {}", (Object)compoundTag, (Object)existingCompoundTag, (Object)this);
            compoundTag = existingCompoundTag.merge(compoundTag);
        } else {
            log.debug("Importing full preset {} for {}", (Object)compoundTag, (Object)this);
        }
        this.getEntity().load(compoundTag);
        Component legacyCustomName = CompoundTagUtils.parseLegacyCustomName(compoundTag, (HolderLookup.Provider)this.getEntity().registryAccess());
        if (legacyCustomName != null) {
            this.getEntity().setCustomName(legacyCustomName);
        }
    }

    default public CompoundTag serializePresetData() {
        CompoundTag compoundTag = new CompoundTag();
        if (this.getEntity() == null) {
            return compoundTag;
        }
        String entityTypeId = this.getEntityTypeId();
        if (entityTypeId != null) {
            compoundTag.putString("id", entityTypeId);
        }
        if (!compoundTag.contains(PRESET_UUID_TAG)) {
            CompoundTagUtils.writeUUID(compoundTag, PRESET_UUID_TAG, UUID.randomUUID());
        }
        CompoundTag entityData = this.getEntity().saveWithoutId(compoundTag);
        for (String entityDataFieldName : ENTITY_DATA_VOLATILE_FIELDS) {
            entityData.remove(entityDataFieldName);
        }
        return entityData;
    }

    default public boolean hasPresetUUID() {
        return this.getPresetUUID() != null;
    }

    default public UUID getPresetUUID() {
        return this.getEasyNPCServerData().getServerEntityData(CUSTOM_DATA_PRESET_UUID);
    }

    default public void setPresetUUID(UUID uuid) {
        this.getEasyNPCServerData().setServerEntityData(CUSTOM_DATA_PRESET_UUID, uuid);
    }

    default public void defineCustomPresetData() {
        this.getEasyNPCServerData().defineServerEntityData(CUSTOM_DATA_PRESET_UUID, null);
    }

    default public void addAdditionalPresetData(CompoundTag compoundTag) {
        if (this.isServerSideInstance() && this.getPresetUUID() != null) {
            CompoundTagUtils.writeUUID(compoundTag, PRESET_UUID_TAG, this.getPresetUUID());
        }
    }

    default public void readAdditionalPresetData(CompoundTag compoundTag) {
        UUID presetUUID = CompoundTagUtils.readUUID(compoundTag, PRESET_UUID_TAG);
        if (presetUUID != null) {
            this.setPresetUUID(presetUUID);
        }
    }
}

