/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.io;

import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.io.DataFileHandler;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CustomPresetDataFiles {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    protected static final String DATA_FOLDER_NAME = "preset";
    private static final ConcurrentHashMap<ResourceLocation, Path> presetResourceLocationMap = new ConcurrentHashMap();

    private CustomPresetDataFiles() {
    }

    public static void registerCustomPresetData() {
        log.info("{} custom preset data ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        Path presetDataFolder = CustomPresetDataFiles.getPresetDataFolder();
        if (presetDataFolder == null) {
            return;
        }
        for (SkinModel skinModel : SkinModel.values()) {
            CustomPresetDataFiles.getPresetDataFolder(skinModel);
        }
    }

    public static Path getPresetDataFolder() {
        return DataFileHandler.getOrCreateCustomDataFolder(DATA_FOLDER_NAME);
    }

    public static Path getPresetDataFolder(SkinModel skinModel) {
        Path skinDataFolder = CustomPresetDataFiles.getPresetDataFolder();
        if (skinDataFolder == null) {
            return null;
        }
        String skinModelName = skinModel.getName();
        Path presetDataFolderPath = skinDataFolder.resolve(skinModelName);
        try {
            if (Files.exists(presetDataFolderPath, new LinkOption[0]) && Files.isDirectory(presetDataFolderPath, new LinkOption[0])) {
                return presetDataFolderPath;
            }
            log.info("Creating preset data folder {} at {} ...", (Object)skinModelName, (Object)presetDataFolderPath);
            return Files.createDirectories(presetDataFolderPath, new FileAttribute[0]);
        }
        catch (IOException exception) {
            log.error("Could not create preset data folder {}:", (Object)skinDataFolder, (Object)exception);
            return null;
        }
    }

    public static File getPresetFile(SkinModel skinModel, String fileName) {
        Path presetModelFolder = CustomPresetDataFiles.getPresetDataFolder(skinModel);
        if (presetModelFolder != null && fileName != null && !fileName.isEmpty()) {
            return presetModelFolder.resolve(CustomPresetDataFiles.getPresetFileName(fileName)).toFile();
        }
        return null;
    }

    public static File getPresetFile(SkinModel skinModel, UUID uuid) {
        return CustomPresetDataFiles.getPresetFile(skinModel, uuid.toString());
    }

    public static String getPresetFileName(String fileName) {
        String result = fileName.replaceAll("[^a-zA-Z0-9/._-]", "").replace("..", "").replace("/", "_");
        return result.endsWith(".npc.nbt") ? result : result + ".npc.nbt";
    }

    public static Stream<ResourceLocation> getPresetResourceLocations(SkinModel skinModel) {
        String searchName = "/" + skinModel.getName() + "/";
        return CustomPresetDataFiles.getPresetResourceLocations().filter(path -> path.toString().contains(searchName) && path.toString().endsWith(".npc.nbt"));
    }

    public static Stream<ResourceLocation> getPresetResourceLocations() {
        Stream<ResourceLocation> stream;
        block8: {
            Path presetDataFolder = CustomPresetDataFiles.getPresetDataFolder();
            Stream<Path> filesStream = Files.walk(presetDataFolder, new FileVisitOption[0]);
            try {
                List<ResourceLocation> filePaths = filesStream.filter(path -> path.toString().endsWith(".npc.nbt")).filter(path -> Pattern.matches("[a-zA-Z0-9/._-]+", path.getFileName().toString())).map(path -> {
                    ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"easy_npc", (String)("preset/" + presetDataFolder.relativize((Path)path).toString().replace("\\", "/").toLowerCase(Locale.ROOT)));
                    presetResourceLocationMap.put(resourceLocation, (Path)path);
                    return resourceLocation;
                }).toList();
                stream = filePaths.stream();
                if (filesStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (filesStream != null) {
                        try {
                            filesStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    log.error("Could not read custom preset data folder {}:", (Object)presetDataFolder, (Object)exception);
                    return Stream.empty();
                }
            }
            filesStream.close();
        }
        return stream;
    }

    public static Path getPresetsResourceLocationPath(ResourceLocation resourceLocation) {
        if (!presetResourceLocationMap.containsKey(resourceLocation)) {
            CustomPresetDataFiles.getPresetResourceLocations();
        }
        return presetResourceLocationMap.get(resourceLocation);
    }
}

