/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.mixin.model;

import de.markusbordihn.easynpc.client.model.EasyNPCModel;
import de.markusbordihn.easynpc.client.model.EasyNPCModelManager;
import de.markusbordihn.easynpc.client.renderer.entity.state.EasyNPCRenderStateExtension;
import de.markusbordihn.easynpc.data.model.ModelPartType;
import net.minecraft.client.model.WolfModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.state.WolfRenderState;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WolfModel.class})
public class EasyNPCWolfModelMixin<T extends WolfRenderState> {
    @Shadow
    @Final
    private ModelPart head;
    @Shadow
    @Final
    private ModelPart body;
    @Shadow
    @Final
    private ModelPart rightFrontLeg;
    @Shadow
    @Final
    private ModelPart leftFrontLeg;
    @Shadow
    @Final
    private ModelPart rightHindLeg;
    @Shadow
    @Final
    private ModelPart leftHindLeg;
    @Shadow
    @Final
    private ModelPart tail;
    @Unique
    private EasyNPCModelManager easyNPC$modelManager;

    @Inject(method={"<init>(Lnet/minecraft/client/model/geom/ModelPart;)V"}, at={@At(value="TAIL")})
    private void easyNpcModel(ModelPart modelPart, CallbackInfo callbackInfo) {
        this.easyNPC$modelManager = new EasyNPCModelManager(modelPart).defineModelPart(ModelPartType.HEAD, this.head).defineModelPart(ModelPartType.BODY, this.body).defineModelPart(ModelPartType.RIGHT_FRONT_LEG, this.rightFrontLeg).defineModelPart(ModelPartType.LEFT_FRONT_LEG, this.leftFrontLeg).defineModelPart(ModelPartType.RIGHT_HIND_LEG, this.rightHindLeg).defineModelPart(ModelPartType.LEFT_HIND_LEG, this.leftHindLeg);
    }

    @Inject(method={"setupAnim(Lnet/minecraft/client/renderer/entity/state/WolfRenderState;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void setupNpcAnim(T renderState, CallbackInfo callbackInfo) {
        EasyNPCRenderStateExtension extension;
        if (renderState instanceof EasyNPCRenderStateExtension && EasyNPCModel.setupAnimationStart(extension = (EasyNPCRenderStateExtension)renderState, this.easyNPC$modelManager)) {
            callbackInfo.cancel();
        }
    }
}

