/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.entity;

import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.client.renderer.entity.EasyNPCLivingEntityRenderer;
import de.markusbordihn.easynpc.client.renderer.entity.state.EasyNPCRenderStateExtension;
import de.markusbordihn.easynpc.client.texture.CustomTextureManager;
import de.markusbordihn.easynpc.client.texture.PlayerTextureManager;
import de.markusbordihn.easynpc.client.texture.RemoteTextureManager;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinDataCapable;
import java.util.function.Supplier;
import net.minecraft.class_10042;
import net.minecraft.class_2960;

public interface EasyNPCEntityRenderer {
    default public boolean hasEasyNPCRenderState(class_10042 livingEntityRenderState) {
        return livingEntityRenderState instanceof EasyNPCRenderStateExtension;
    }

    public class_2960 getTextureByVariant(Enum<?> var1);

    public class_2960 getDefaultTexture();

    default public class_2960 getCustomTexture(SkinDataCapable<?> entity) {
        return CustomTextureManager.getOrCreateTextureWithDefault(entity, this.getDefaultTexture());
    }

    default public class_2960 getPlayerTexture(SkinDataCapable<?> entity) {
        return PlayerTextureManager.getOrCreateTextureWithDefault(entity, this.getDefaultTexture());
    }

    default public class_2960 getRemoteTexture(SkinDataCapable<?> entity) {
        return RemoteTextureManager.getOrCreateTextureWithDefault(entity, this.getDefaultTexture());
    }

    default public EasyNPC<?> getEasyNPC(class_10042 livingEntityRenderState) {
        return EasyNPCLivingEntityRenderer.getEasyNPC(livingEntityRenderState);
    }

    default public class_2960 getEntityTexture(EasyNPC<?> easyNPC) {
        SkinDataCapable skinData = easyNPC.getEasyNPCSkinData();
        return switch (skinData.getSkinType()) {
            case SkinType.NONE -> Constants.BLANK_ENTITY_TEXTURE;
            case SkinType.CUSTOM -> this.getCustomTexture(skinData);
            case SkinType.SECURE_REMOTE_URL, SkinType.INSECURE_REMOTE_URL -> this.getRemoteTexture(skinData);
            default -> this.getTextureByVariant(easyNPC.getEasyNPCVariantData().getVariantType());
        };
    }

    default public class_2960 getEntityPlayerTexture(EasyNPC<?> easyNPC) {
        SkinDataCapable skinData = easyNPC.getEasyNPCSkinData();
        return switch (skinData.getSkinType()) {
            case SkinType.NONE -> Constants.BLANK_ENTITY_TEXTURE;
            case SkinType.CUSTOM -> this.getCustomTexture(skinData);
            case SkinType.PLAYER_SKIN -> this.getPlayerTexture(skinData);
            case SkinType.SECURE_REMOTE_URL, SkinType.INSECURE_REMOTE_URL -> this.getRemoteTexture(skinData);
            default -> this.getTextureByVariant(easyNPC.getEasyNPCVariantData().getVariantType());
        };
    }

    default public class_2960 getEntityTextureWithDefaultCallback(EasyNPC<?> easyNPC, Supplier<class_2960> defaultTextureSupplier) {
        SkinDataCapable skinData = easyNPC.getEasyNPCSkinData();
        return switch (skinData.getSkinType()) {
            case SkinType.NONE -> Constants.BLANK_ENTITY_TEXTURE;
            case SkinType.CUSTOM -> this.getCustomTexture(skinData);
            case SkinType.SECURE_REMOTE_URL, SkinType.INSECURE_REMOTE_URL -> this.getRemoteTexture(skinData);
            default -> defaultTextureSupplier.get();
        };
    }
}

