/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.entity.custom;

import de.markusbordihn.easynpc.client.renderer.entity.EasyNPCEntityRenderer;
import de.markusbordihn.easynpc.client.renderer.entity.state.EasyNPCRenderStateExtension;
import de.markusbordihn.easynpc.client.renderer.manager.EntityTypeManager;
import de.markusbordihn.easynpc.client.renderer.manager.RendererManager;
import de.markusbordihn.easynpc.data.render.RenderType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.RenderDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.npc.custom.Doppler;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.class_10017;
import net.minecraft.class_10042;
import net.minecraft.class_10055;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5602;
import net.minecraft.class_5617;
import net.minecraft.class_5697;
import net.minecraft.class_572;
import net.minecraft.class_583;
import net.minecraft.class_591;
import net.minecraft.class_8136;
import net.minecraft.class_897;
import net.minecraft.class_922;
import net.minecraft.class_970;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DopplerRenderer
extends class_922<class_1314, class_10055, class_591>
implements EasyNPCEntityRenderer {
    protected static final Map<Doppler.VariantType, class_2960> TEXTURE_BY_VARIANT_TYPE = (Map)class_156.method_654(new EnumMap(Doppler.VariantType.class), map -> map.put(Doppler.VariantType.DEFAULT, class_2960.method_60655((String)"easy_npc", (String)"textures/entity/doppler/doppler.png")));
    protected static final class_2960 DEFAULT_TEXTURE = TEXTURE_BY_VARIANT_TYPE.get((Object)Doppler.VariantType.DEFAULT);
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    public DopplerRenderer(class_5617.class_5618 context) {
        this(context, false);
    }

    public DopplerRenderer(class_5617.class_5618 context, boolean slim) {
        super(context, (class_583)new class_591(context.method_32167(slim ? class_5602.field_27581 : class_5602.field_27577), slim), 0.5f);
        this.method_4046((class_3887)new class_970((class_3883)this, (class_572)new class_8136(context.method_32167(slim ? class_5602.field_27582 : class_5602.field_27579)), (class_572)new class_8136(context.method_32167(slim ? class_5602.field_27583 : class_5602.field_27580)), context.method_64072()));
        this.method_4046((class_3887)new class_5697((class_3883)this));
    }

    private static boolean renderEntity(EasyNPC<?> entity, class_583<?> entityModel, class_10055 renderState, class_4587 poseStack, class_4597 buffer, int packedLight) {
        if (!(entity instanceof EasyNPC)) {
            return false;
        }
        EasyNPC<?> easyNPC = entity;
        RenderDataCapable renderData = easyNPC.getEasyNPCRenderData();
        if (renderData == null || renderData.getRenderDataSet() == null || renderData.getRenderDataSet().getRenderType() != RenderType.CUSTOM_ENTITY) {
            return false;
        }
        class_1299<? extends class_1297> renderEntityType = renderData.getRenderDataSet().getRenderEntityType();
        class_1314 customEntity = EntityTypeManager.getPathfinderMob(renderEntityType, entity.getEntityLevel());
        if (customEntity == null) {
            return false;
        }
        String entityTypeName = EntityTypeManager.getEntityTypeName(renderEntityType);
        class_922<? extends class_1309, ? extends class_10042, ? extends class_583<? extends class_10017>> livingEntityRenderer = RendererManager.getLivingEntityRenderer(renderEntityType, customEntity);
        class_10042 livingEntityRenderState = (class_10042)livingEntityRenderer.method_62425((class_1297)customEntity, 0.0f);
        if (livingEntityRenderState instanceof EasyNPCRenderStateExtension) {
            EasyNPCRenderStateExtension extension = (EasyNPCRenderStateExtension)livingEntityRenderState;
            extension.setEasyNpcUUID(easyNPC.getEntityUUID());
        }
        if (livingEntityRenderer != null) {
            try {
                RendererManager.copyCustomLivingEntityData(entity.getPathfinderMob(), (class_1309)customEntity, entityTypeName);
                livingEntityRenderer.method_4054(livingEntityRenderState, poseStack, buffer, packedLight);
                return true;
            }
            catch (Exception exception) {
                log.error("Failed to render custom living entity {} ({}):", (Object)customEntity, renderEntityType, (Object)exception);
                EntityTypeManager.addUnsupportedEntityType(renderEntityType);
                return false;
            }
        }
        class_897<? extends class_1297, ? extends class_10017> entityRenderer = RendererManager.getEntityRenderer(renderEntityType, customEntity);
        class_10017 entityRenderState = entityRenderer.method_62425((class_1297)customEntity, 0.0f);
        if (entityRenderState instanceof EasyNPCRenderStateExtension) {
            EasyNPCRenderStateExtension extension = (EasyNPCRenderStateExtension)entityRenderState;
            extension.setEasyNpcUUID(easyNPC.getEntityUUID());
        }
        if (entityRenderer != null) {
            try {
                RendererManager.copyCustomLivingEntityData(entity.getPathfinderMob(), (class_1309)customEntity, entityTypeName);
                entityRenderer.method_3936(entityRenderState, poseStack, buffer, packedLight);
                return true;
            }
            catch (Exception exception) {
                log.error("Failed to render custom entity {} ({}):", (Object)customEntity, renderEntityType, (Object)exception);
                EntityTypeManager.addUnsupportedEntityType(renderEntityType);
                return false;
            }
        }
        return false;
    }

    public class_10055 createRenderState() {
        return new class_10055();
    }

    public class_2960 getTextureLocation(class_10055 renderState) {
        EasyNPC easyNPC = this.getEasyNPC((class_10042)renderState);
        if (easyNPC != null) {
            return this.getEntityTexture(easyNPC);
        }
        return DEFAULT_TEXTURE;
    }

    @Override
    public class_2960 getDefaultTexture() {
        return DEFAULT_TEXTURE;
    }

    @Override
    public class_2960 getTextureByVariant(Enum<?> variantType) {
        return TEXTURE_BY_VARIANT_TYPE.getOrDefault(variantType, DEFAULT_TEXTURE);
    }

    public void render(class_10055 renderState, class_4587 poseStack, class_4597 buffer, int packedLight) {
        EasyNPC easyNPC = this.getEasyNPC((class_10042)renderState);
        if (DopplerRenderer.renderEntity(easyNPC, this.method_4038(), renderState, poseStack, buffer, packedLight)) {
            return;
        }
        super.method_4054((class_10042)renderState, poseStack, buffer, packedLight);
    }
}

