/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.commands.arguments;

import com.google.common.collect.Maps;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.markusbordihn.easynpc.network.components.TextComponent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1304;
import net.minecraft.class_156;
import net.minecraft.class_2168;
import net.minecraft.class_2172;

public class EquipmentSlotArgument
implements ArgumentType<class_1304> {
    private static final Collection<String> EXAMPLES = Arrays.asList("weapon.mainhand", "weapon.offhand");
    private static final DynamicCommandExceptionType ERROR_UNKNOWN_SLOT = new DynamicCommandExceptionType(slot -> TextComponent.getTranslatedTextRaw("slot.unknown", slot.toString()));
    private static final Map<String, class_1304> SLOTS = (Map)class_156.method_654((Object)Maps.newHashMap(), map -> {
        map.put("weapon", class_1304.field_6173);
        map.put("weapon.mainhand", class_1304.field_6173);
        map.put("weapon.offhand", class_1304.field_6171);
        map.put("armor.head", class_1304.field_6169);
        map.put("armor.chest", class_1304.field_6174);
        map.put("armor.legs", class_1304.field_6172);
        map.put("armor.feet", class_1304.field_6166);
    });

    public static EquipmentSlotArgument slot() {
        return new EquipmentSlotArgument();
    }

    public static class_1304 getEquipmentSlot(CommandContext<class_2168> commandContext, String slotName) {
        return (class_1304)commandContext.getArgument(slotName, class_1304.class);
    }

    public class_1304 parse(StringReader stringReader) throws CommandSyntaxException {
        String key = stringReader.readUnquotedString();
        if (!SLOTS.containsKey(key)) {
            throw ERROR_UNKNOWN_SLOT.create((Object)key);
        }
        return SLOTS.get(key);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> commandContext, SuggestionsBuilder suggestionsBuilder) {
        return class_2172.method_9265(SLOTS.keySet(), (SuggestionsBuilder)suggestionsBuilder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

