/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.action;

import de.markusbordihn.easynpc.data.action.ActionDataEntry;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public final class ActionDataSet {
    public static final String ACTION_DATA_SET_TAG = "ActionDataSet";
    private final Set<ActionDataEntry> actionDataEntries = new LinkedHashSet<ActionDataEntry>();

    public ActionDataSet() {
    }

    public ActionDataSet(class_2487 compoundTag) {
        this.load(compoundTag, ACTION_DATA_SET_TAG);
    }

    public ActionDataSet(class_2487 compoundTag, String listName) {
        this.load(compoundTag, listName);
    }

    public void add(ActionDataEntry actionDataEntry) {
        if (actionDataEntry != null) {
            this.actionDataEntries.add(actionDataEntry);
        }
    }

    public void remove(ActionDataEntry actionDataEntry) {
        if (actionDataEntry != null) {
            this.actionDataEntries.remove(actionDataEntry);
        }
    }

    public void remove(UUID actionDataEntryId) {
        ActionDataEntry actionDataEntry;
        if (actionDataEntryId != null && (actionDataEntry = this.getEntry(actionDataEntryId)) != null) {
            this.actionDataEntries.remove(actionDataEntry);
        }
    }

    public void put(UUID actionDataEntryId, ActionDataEntry actionDataEntry) {
        if (actionDataEntryId == null || actionDataEntry == null) {
            return;
        }
        ArrayList<ActionDataEntry> indexedActionDataSet = new ArrayList<ActionDataEntry>(this.actionDataEntries);
        int index = -1;
        for (int i = 0; i < indexedActionDataSet.size(); ++i) {
            if (!indexedActionDataSet.get(i).getId().equals(actionDataEntryId)) continue;
            index = i;
            break;
        }
        if (index >= 0) {
            indexedActionDataSet.set(index, actionDataEntry);
        } else {
            indexedActionDataSet.add(actionDataEntry);
        }
        this.actionDataEntries.clear();
        this.actionDataEntries.addAll(indexedActionDataSet);
    }

    public void moveUp(ActionDataEntry actionDataEntry) {
        if (actionDataEntry == null) {
            return;
        }
        int position = this.getPosition(actionDataEntry);
        if (position <= 0) {
            return;
        }
        ArrayList<ActionDataEntry> indexedActionDataSet = new ArrayList<ActionDataEntry>(this.actionDataEntries);
        ActionDataEntry previousActionDataEntry = indexedActionDataSet.get(position - 1);
        indexedActionDataSet.set(position - 1, actionDataEntry);
        indexedActionDataSet.set(position, previousActionDataEntry);
        this.actionDataEntries.clear();
        this.actionDataEntries.addAll(indexedActionDataSet);
    }

    public void moveDown(ActionDataEntry actionDataEntry) {
        if (actionDataEntry == null) {
            return;
        }
        int position = this.getPosition(actionDataEntry);
        if (position < 0 || position >= this.actionDataEntries.size() - 1) {
            return;
        }
        ArrayList<ActionDataEntry> indexedActionDataSet = new ArrayList<ActionDataEntry>(this.actionDataEntries);
        ActionDataEntry nextActionDataEntry = indexedActionDataSet.get(position + 1);
        indexedActionDataSet.set(position + 1, actionDataEntry);
        indexedActionDataSet.set(position, nextActionDataEntry);
        this.actionDataEntries.clear();
        this.actionDataEntries.addAll(indexedActionDataSet);
    }

    public boolean isEmpty() {
        return this.actionDataEntries.isEmpty();
    }

    public boolean hasActionData() {
        if (this.actionDataEntries.isEmpty()) {
            return false;
        }
        for (ActionDataEntry action : this.actionDataEntries) {
            if (!action.isValidAndNotEmpty()) continue;
            return true;
        }
        return false;
    }

    public Iterator<ActionDataEntry> iterator() {
        return this.actionDataEntries.iterator();
    }

    public int size() {
        return this.actionDataEntries.size();
    }

    public ActionDataEntry getRandomEntry() {
        if (this.actionDataEntries.isEmpty()) {
            return null;
        }
        return this.actionDataEntries.iterator().next();
    }

    public Set<ActionDataEntry> getEntries() {
        return this.actionDataEntries;
    }

    public ActionDataEntry getEntry(UUID actionDataEntryId) {
        if (actionDataEntryId == null) {
            return null;
        }
        for (ActionDataEntry actionDataEntry : this.actionDataEntries) {
            if (!actionDataEntry.getId().equals(actionDataEntryId)) continue;
            return actionDataEntry;
        }
        return null;
    }

    public boolean contains(UUID actionDataEntryId) {
        return this.getEntry(actionDataEntryId) != null;
    }

    public boolean contains(ActionDataEntry actionDataEntry) {
        return this.actionDataEntries.contains(actionDataEntry);
    }

    public int getPosition(ActionDataEntry actionDataEntry) {
        if (actionDataEntry == null) {
            return -1;
        }
        int position = 0;
        for (ActionDataEntry entry : this.actionDataEntries) {
            if (entry.getId().equals(actionDataEntry.getId())) {
                return position;
            }
            ++position;
        }
        return -1;
    }

    public ActionDataEntry getEntryOrDefault(UUID actionDataEntryId) {
        ActionDataEntry actionDataEntry = this.getEntry(actionDataEntryId);
        return actionDataEntry != null ? actionDataEntry : new ActionDataEntry();
    }

    public ActionDataSet load(class_2487 compoundTag, String listName) {
        if (compoundTag == null || listName == null || listName.isEmpty() || !compoundTag.method_10545(listName)) {
            return new ActionDataSet();
        }
        class_2499 actionDataList = compoundTag.method_68569(listName);
        return this.load(actionDataList);
    }

    public ActionDataSet load(class_2499 actionDataList) {
        if (actionDataList == null || actionDataList.isEmpty()) {
            return new ActionDataSet();
        }
        this.actionDataEntries.clear();
        for (int i = 0; i < actionDataList.size(); ++i) {
            class_2487 actionDataEntryTag = actionDataList.method_68582(i);
            ActionDataEntry actionDataEntry = new ActionDataEntry(actionDataEntryTag);
            this.actionDataEntries.add(actionDataEntry);
        }
        return this;
    }

    public void save(class_2487 compoundTag, String listName) {
        class_2499 actionDataList = new class_2499();
        this.save(actionDataList);
        compoundTag.method_10566(listName, (class_2520)actionDataList);
    }

    public void save(class_2499 actionDataList) {
        if (actionDataList == null) {
            return;
        }
        for (ActionDataEntry actionDataEntry : this.actionDataEntries) {
            if (actionDataEntry == null || !actionDataEntry.isValidAndNotEmpty()) continue;
            actionDataList.add((Object)actionDataEntry.createTag());
        }
    }

    public class_2487 createTag() {
        class_2487 compoundTag = new class_2487();
        this.save(compoundTag, ACTION_DATA_SET_TAG);
        return compoundTag;
    }

    public String toString() {
        return this.actionDataEntries.toString();
    }
}

