/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.attribute;

import de.markusbordihn.easynpc.data.attribute.BaseAttributeType;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_5134;

public class BaseAttributes {
    public static final String ATTACK_DAMAGE_TAG = BaseAttributeType.ATTACK_DAMAGE.getTagName();
    public static final String ATTACK_KNOCKBACK_TAG = BaseAttributeType.ATTACK_KNOCKBACK.getTagName();
    public static final String BASE_ATTRIBUTES_TAG = "BaseAttributes";
    public static final String FOLLOW_RANGE_TAG = BaseAttributeType.FOLLOW_RANGE.getTagName();
    public static final String KNOCKBACK_RESISTANCE_TAG = BaseAttributeType.KNOCKBACK_RESISTANCE.getTagName();
    private double attackDamage = 2.0;
    private double attackKnockback = 0.0;
    private double followRange = 32.0;
    private double knockbackResistance = 0.0;

    public BaseAttributes() {
    }

    public BaseAttributes(class_2487 compoundTag) {
        this.load(compoundTag);
    }

    public BaseAttributes(class_1309 livingEntity) {
        if (livingEntity == null) {
            return;
        }
        if (livingEntity.method_5996(class_5134.field_23717) != null) {
            this.setFollowRange(livingEntity.method_5996(class_5134.field_23717).method_6201());
        }
        if (livingEntity.method_5996(class_5134.field_23718) != null) {
            this.setKnockbackResistance(livingEntity.method_5996(class_5134.field_23718).method_6201());
        }
        if (livingEntity.method_5996(class_5134.field_23721) != null) {
            this.setAttackDamage(livingEntity.method_5996(class_5134.field_23721).method_6201());
        }
        if (livingEntity.method_5996(class_5134.field_23722) != null) {
            this.setAttackKnockback(livingEntity.method_5996(class_5134.field_23722).method_6201());
        }
    }

    public void load(class_2487 compoundTag) {
        if (!compoundTag.method_10545(BASE_ATTRIBUTES_TAG)) {
            return;
        }
        class_2487 baseAttributesTag = compoundTag.method_68568(BASE_ATTRIBUTES_TAG);
        if (baseAttributesTag.method_10545(FOLLOW_RANGE_TAG)) {
            this.setFollowRange(baseAttributesTag.method_10574(FOLLOW_RANGE_TAG).orElse(0.0));
        }
        if (baseAttributesTag.method_10545(KNOCKBACK_RESISTANCE_TAG)) {
            this.setKnockbackResistance(baseAttributesTag.method_10574(KNOCKBACK_RESISTANCE_TAG).orElse(0.0));
        }
        if (baseAttributesTag.method_10545(ATTACK_DAMAGE_TAG)) {
            this.setAttackDamage(baseAttributesTag.method_10574(ATTACK_DAMAGE_TAG).orElse(0.0));
        }
        if (baseAttributesTag.method_10545(ATTACK_KNOCKBACK_TAG)) {
            this.setAttackKnockback(baseAttributesTag.method_10574(ATTACK_KNOCKBACK_TAG).orElse(0.0));
        }
    }

    public class_2487 save(class_2487 compoundTag) {
        class_2487 baseAttributesTag = new class_2487();
        baseAttributesTag.method_10549(FOLLOW_RANGE_TAG, (double)((float)this.getFollowRange()));
        baseAttributesTag.method_10549(KNOCKBACK_RESISTANCE_TAG, (double)((float)this.getKnockbackResistance()));
        baseAttributesTag.method_10549(ATTACK_DAMAGE_TAG, (double)((float)this.getAttackDamage()));
        baseAttributesTag.method_10549(ATTACK_KNOCKBACK_TAG, (double)((float)this.getAttackKnockback()));
        compoundTag.method_10566(BASE_ATTRIBUTES_TAG, (class_2520)baseAttributesTag);
        return compoundTag;
    }

    public class_2487 createTag() {
        return this.save(new class_2487());
    }

    public double getFollowRange() {
        return this.followRange;
    }

    public void setFollowRange(double followRange) {
        this.followRange = followRange;
    }

    public double getKnockbackResistance() {
        return this.knockbackResistance;
    }

    public void setKnockbackResistance(double knockbackResistance) {
        this.knockbackResistance = knockbackResistance;
    }

    public double getAttackDamage() {
        return this.attackDamage;
    }

    public void setAttackDamage(double attackDamage) {
        this.attackDamage = attackDamage;
    }

    public double getAttackKnockback() {
        return this.attackKnockback;
    }

    public void setAttackKnockback(double attackKnockback) {
        this.attackKnockback = attackKnockback;
    }
}

