/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.screen;

import de.markusbordihn.easynpc.data.action.ActionEventSet;
import de.markusbordihn.easynpc.data.action.ActionEventType;
import de.markusbordihn.easynpc.data.attribute.BaseAttributes;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.data.dialog.DialogDataSet;
import de.markusbordihn.easynpc.data.editor.EditorType;
import de.markusbordihn.easynpc.data.objective.ObjectiveDataSet;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class AdditionalScreenData {
    private static final String ACTION_EVENT_DATA_TAG = "ActionEventData";
    private static final String ACTION_EVENT_TYPE_TAG = "ActionEventType";
    private static final String BASE_ATTRIBUTES_DATA_TAG = "BaseAttributesData";
    private static final String CONFIGURATION_TYPE_TAG = "ConfigurationType";
    private static final String DIALOG_DATA_TAG = "DialogData";
    private static final String EDITOR_TYPE_TAG = "EditorType";
    private static final String OBJECTIVE_DATA_TAG = "ObjectiveData";
    private final ActionEventSet actionEventSet;
    private final ActionEventType actionEventType;
    private final BaseAttributes baseAttributes;
    private final class_2487 data;
    private final ConfigurationType configurationType;
    private final DialogDataSet dialogDataSet;
    private final EditorType editorType;
    private final ObjectiveDataSet objectiveDataSet;

    public AdditionalScreenData(class_2487 compoundTag) {
        this.actionEventSet = AdditionalScreenData.getActionEventSet(compoundTag);
        this.actionEventType = AdditionalScreenData.getActionEventType(compoundTag);
        this.baseAttributes = AdditionalScreenData.getBaseAttributes(compoundTag);
        this.configurationType = AdditionalScreenData.getConfigurationType(compoundTag);
        this.dialogDataSet = AdditionalScreenData.getDialogDataSet(compoundTag);
        this.editorType = AdditionalScreenData.getEditorType(compoundTag);
        this.objectiveDataSet = AdditionalScreenData.getObjectiveDataSet(compoundTag);
        this.data = compoundTag;
        this.data.method_10551(ACTION_EVENT_DATA_TAG);
        this.data.method_10551(ACTION_EVENT_TYPE_TAG);
        this.data.method_10551(BASE_ATTRIBUTES_DATA_TAG);
        this.data.method_10551(CONFIGURATION_TYPE_TAG);
        this.data.method_10551(DIALOG_DATA_TAG);
        this.data.method_10551(EDITOR_TYPE_TAG);
        this.data.method_10551(OBJECTIVE_DATA_TAG);
    }

    public static void addActionEventType(class_2487 compoundTag, ActionEventType actionEventType) {
        if (compoundTag == null || actionEventType == null) {
            return;
        }
        compoundTag.method_10582(ACTION_EVENT_TYPE_TAG, actionEventType.name());
    }

    public static ActionEventType getActionEventType(class_2487 compoundTag) {
        if (!AdditionalScreenData.hasActionEventType(compoundTag)) {
            return ActionEventType.NONE;
        }
        return ActionEventType.get(compoundTag.method_10558(ACTION_EVENT_TYPE_TAG).orElse(""));
    }

    public static boolean hasActionEventType(class_2487 compoundTag) {
        return compoundTag != null && compoundTag.method_10545(ACTION_EVENT_TYPE_TAG);
    }

    public static void addActionEventSet(class_2487 compoundTag, EasyNPC<?> easyNPC) {
        if (compoundTag == null || easyNPC == null || easyNPC.getEasyNPCActionEventData() == null) {
            return;
        }
        compoundTag.method_10566(ACTION_EVENT_DATA_TAG, (class_2520)easyNPC.getEasyNPCActionEventData().getActionEventSet().createTag());
    }

    public static ActionEventSet getActionEventSet(class_2487 compoundTag) {
        if (!AdditionalScreenData.hasActionEventSet(compoundTag)) {
            return new ActionEventSet();
        }
        return new ActionEventSet(compoundTag.method_68568(ACTION_EVENT_DATA_TAG));
    }

    public static boolean hasActionEventSet(class_2487 compoundTag) {
        return compoundTag != null && compoundTag.method_10545(ACTION_EVENT_DATA_TAG);
    }

    public static void addBaseAttributes(class_2487 compoundTag, EasyNPC<?> easyNPC) {
        if (compoundTag == null || easyNPC == null || easyNPC.getLivingEntity() == null) {
            return;
        }
        compoundTag.method_10566(BASE_ATTRIBUTES_DATA_TAG, (class_2520)new BaseAttributes(easyNPC.getLivingEntity()).createTag());
    }

    public static BaseAttributes getBaseAttributes(class_2487 compoundTag) {
        if (!AdditionalScreenData.hasBaseAttributes(compoundTag)) {
            return new BaseAttributes();
        }
        return new BaseAttributes(compoundTag.method_68568(BASE_ATTRIBUTES_DATA_TAG));
    }

    public static boolean hasBaseAttributes(class_2487 compoundTag) {
        return compoundTag != null && compoundTag.method_10545(BASE_ATTRIBUTES_DATA_TAG);
    }

    public static void addConfigurationType(class_2487 compoundTag, ConfigurationType configurationType) {
        if (compoundTag == null || configurationType == null) {
            return;
        }
        compoundTag.method_10582(CONFIGURATION_TYPE_TAG, configurationType.name());
    }

    public static ConfigurationType getConfigurationType(class_2487 compoundTag) {
        if (!AdditionalScreenData.hasConfigurationType(compoundTag)) {
            return ConfigurationType.NONE;
        }
        return ConfigurationType.get(compoundTag.method_10558(CONFIGURATION_TYPE_TAG).orElse(""));
    }

    public static boolean hasConfigurationType(class_2487 compoundTag) {
        return compoundTag != null && compoundTag.method_10545(CONFIGURATION_TYPE_TAG);
    }

    public static void addDialogDataSet(class_2487 compoundTag, EasyNPC<?> easyNPC) {
        if (compoundTag == null || easyNPC == null || easyNPC.getEasyNPCDialogData() == null) {
            return;
        }
        compoundTag.method_10566(DIALOG_DATA_TAG, (class_2520)easyNPC.getEasyNPCDialogData().getDialogDataSet().createTag());
    }

    public static DialogDataSet getDialogDataSet(class_2487 compoundTag) {
        if (!AdditionalScreenData.hasDialogDataSet(compoundTag)) {
            return new DialogDataSet();
        }
        return new DialogDataSet(compoundTag.method_68568(DIALOG_DATA_TAG));
    }

    public static boolean hasDialogDataSet(class_2487 compoundTag) {
        return compoundTag != null && compoundTag.method_10545(DIALOG_DATA_TAG);
    }

    public static void addEditorType(class_2487 compoundTag, EditorType editorType) {
        if (compoundTag == null || editorType == null) {
            return;
        }
        compoundTag.method_10582(EDITOR_TYPE_TAG, editorType.name());
    }

    public static EditorType getEditorType(class_2487 compoundTag) {
        if (!AdditionalScreenData.hasEditorType(compoundTag)) {
            return EditorType.NONE;
        }
        return EditorType.get(compoundTag.method_10558(EDITOR_TYPE_TAG).orElse(""));
    }

    public static boolean hasEditorType(class_2487 compoundTag) {
        return compoundTag != null && compoundTag.method_10545(EDITOR_TYPE_TAG);
    }

    public static void addObjectiveDataSet(class_2487 compoundTag, EasyNPC<?> easyNPC) {
        if (compoundTag == null || easyNPC == null || easyNPC.getEasyNPCObjectiveData() == null) {
            return;
        }
        compoundTag.method_10566(OBJECTIVE_DATA_TAG, (class_2520)easyNPC.getEasyNPCObjectiveData().getObjectiveDataSet().createTag());
    }

    public static ObjectiveDataSet getObjectiveDataSet(class_2487 compoundTag) {
        if (!AdditionalScreenData.hasObjectiveDataSet(compoundTag)) {
            return new ObjectiveDataSet();
        }
        return new ObjectiveDataSet(compoundTag.method_68568(OBJECTIVE_DATA_TAG));
    }

    public static boolean hasObjectiveDataSet(class_2487 compoundTag) {
        return compoundTag != null && compoundTag.method_10545(OBJECTIVE_DATA_TAG);
    }

    public ActionEventType getActionEventType() {
        return this.actionEventType;
    }

    public ActionEventSet getActionEventSet() {
        return this.actionEventSet;
    }

    public BaseAttributes getBaseAttributes() {
        return this.baseAttributes;
    }

    public ConfigurationType getConfigurationType() {
        return this.configurationType;
    }

    public DialogDataSet getDialogDataSet() {
        return this.dialogDataSet;
    }

    public EditorType getEditorType() {
        return this.editorType;
    }

    public ObjectiveDataSet getObjectiveDataSet() {
        return this.objectiveDataSet;
    }

    public class_2487 getData() {
        return this.data;
    }

    public class_2487 get(String dataTag) {
        if (this.data.method_10545(dataTag)) {
            return this.data.method_68568(dataTag);
        }
        return new class_2487();
    }

    public class_2499 getList(String dataTag) {
        if (this.data.method_10545(dataTag)) {
            return this.data.method_68569(dataTag);
        }
        return new class_2499();
    }

    public boolean hasDialogDataSet() {
        return this.dialogDataSet != null;
    }
}

