/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.display.DisplayAttributeEntry;
import de.markusbordihn.easynpc.data.display.DisplayAttributeType;
import de.markusbordihn.easynpc.data.display.NameVisibilityType;
import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.data.type.ValueType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.network.syncher.EntityDataSerializersManager;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1314;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2945;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public interface DisplayAttributeDataCapable<E extends class_1314>
extends EasyNPC<E> {
    public static final String DATA_DISPLAY_ATTRIBUTE_SET_TAG = "DisplayAttribute";
    public static final class_9139<class_9129, EnumMap<DisplayAttributeType, DisplayAttributeEntry>> STREAM_CODEC = new class_9139<class_9129, EnumMap<DisplayAttributeType, DisplayAttributeEntry>>(){

        public EnumMap<DisplayAttributeType, DisplayAttributeEntry> decode(class_9129 registryFriendlyByteBuf) {
            class_2487 compoundTag = registryFriendlyByteBuf.method_10798();
            EnumMap<DisplayAttributeType, DisplayAttributeEntry> displayAttributeMap = new EnumMap<DisplayAttributeType, DisplayAttributeEntry>(DisplayAttributeType.class);
            for (String key : compoundTag.method_10541()) {
                DisplayAttributeType displayAttributeType = DisplayAttributeType.get(key);
                if (displayAttributeType == null) continue;
                displayAttributeMap.put(displayAttributeType, new DisplayAttributeEntry(compoundTag.method_68568(key)));
            }
            return displayAttributeMap;
        }

        public void encode(class_9129 registryFriendlyByteBuf, EnumMap<DisplayAttributeType, DisplayAttributeEntry> displayAttributeMap) {
            class_2487 compoundTag = new class_2487();
            for (Map.Entry<DisplayAttributeType, DisplayAttributeEntry> entry : displayAttributeMap.entrySet()) {
                class_2487 entryTag = new class_2487();
                entry.getValue().write(entryTag);
                compoundTag.method_10566(entry.getKey().name(), (class_2520)entryTag);
            }
            registryFriendlyByteBuf.method_10794((class_2520)compoundTag);
        }
    };

    public static void registerSyncedDisplayAttributeData(EnumMap<SynchedDataIndex, class_2940<?>> map, Class<? extends class_1297> entityClass) {
        log.info("- Registering Synched Display Attribute Data for {}.", (Object)entityClass.getSimpleName());
        map.put(SynchedDataIndex.DISPLAY_ATTRIBUTE_SET, class_2945.method_12791(entityClass, EntityDataSerializersManager.DISPLAY_ATTRIBUTE));
    }

    default public EnumMap<DisplayAttributeType, DisplayAttributeEntry> getDisplayAttributeMap() {
        EnumMap<DisplayAttributeType, DisplayAttributeEntry> displayAttributeMap = (EnumMap<DisplayAttributeType, DisplayAttributeEntry>)this.getSynchedEntityData(SynchedDataIndex.DISPLAY_ATTRIBUTE_SET);
        if (displayAttributeMap == null) {
            displayAttributeMap = this.createDefaultDisplayAttributeMap();
            this.setDisplayAttributeMap(displayAttributeMap);
        }
        return displayAttributeMap;
    }

    default public void setDisplayAttributeMap(EnumMap<DisplayAttributeType, DisplayAttributeEntry> displayAttributeMap) {
        if (displayAttributeMap != null) {
            this.setSynchedEntityData(SynchedDataIndex.DISPLAY_ATTRIBUTE_SET, displayAttributeMap, true);
        }
    }

    default public void clearDisplayAttributeMap() {
        this.setSynchedEntityData(SynchedDataIndex.DISPLAY_ATTRIBUTE_SET, this.createDefaultDisplayAttributeMap());
    }

    default public void updateDisplayAttributeMap() {
        EnumMap<DisplayAttributeType, DisplayAttributeEntry> displayAttributeMap = this.getDisplayAttributeMap();
        if (displayAttributeMap != null) {
            this.setDisplayAttributeMap(new EnumMap<DisplayAttributeType, DisplayAttributeEntry>(displayAttributeMap));
        }
    }

    default public boolean hasDisplayAttribute(DisplayAttributeType displayAttributeType) {
        EnumMap<DisplayAttributeType, DisplayAttributeEntry> displayAttributeMap = this.getDisplayAttributeMap();
        return displayAttributeMap.containsKey((Object)displayAttributeType);
    }

    default public boolean getDisplayBooleanAttribute(DisplayAttributeType displayAttributeType) {
        EnumMap<DisplayAttributeType, DisplayAttributeEntry> displayAttributeMap = this.getDisplayAttributeMap();
        DisplayAttributeEntry entry = displayAttributeMap.get((Object)displayAttributeType);
        return entry != null ? entry.booleanValue() : false;
    }

    default public int getDisplayIntAttribute(DisplayAttributeType displayAttributeType) {
        EnumMap<DisplayAttributeType, DisplayAttributeEntry> displayAttributeMap = this.getDisplayAttributeMap();
        DisplayAttributeEntry entry = displayAttributeMap.get((Object)displayAttributeType);
        return entry != null ? entry.intValue() : 0;
    }

    default public String getDisplayStringAttribute(DisplayAttributeType displayAttributeType) {
        EnumMap<DisplayAttributeType, DisplayAttributeEntry> displayAttributeMap = this.getDisplayAttributeMap();
        DisplayAttributeEntry entry = displayAttributeMap.get((Object)displayAttributeType);
        return entry != null ? entry.stringValue() : "";
    }

    default public <T extends Enum<T>> T getDisplayEnumAttribute(DisplayAttributeType displayAttributeType, Class<T> enumClass) {
        String enumValue = this.getDisplayStringAttribute(displayAttributeType);
        try {
            return Enum.valueOf(enumClass, enumValue);
        }
        catch (IllegalArgumentException e) {
            log.error("Failed to get enum value {} for class {}: {}", (Object)enumValue, enumClass, (Object)e);
            return null;
        }
    }

    default public <T> void setDisplayAttribute(DisplayAttributeType displayAttributeType, ValueType valueType, T value) {
        EnumMap<DisplayAttributeType, DisplayAttributeEntry> displayAttributeMap = this.getDisplayAttributeMap();
        switch (valueType) {
            case BOOLEAN: {
                displayAttributeMap.put(displayAttributeType, new DisplayAttributeEntry((Boolean)value));
                break;
            }
            case INTEGER: {
                displayAttributeMap.put(displayAttributeType, new DisplayAttributeEntry((Integer)value));
                break;
            }
            case STRING: {
                displayAttributeMap.put(displayAttributeType, new DisplayAttributeEntry((String)value));
                break;
            }
            default: {
                log.error("Invalid display value type {} for {}", (Object)valueType, (Object)displayAttributeType);
                return;
            }
        }
        this.updateDisplayAttributeMap();
    }

    default public void setDisplayAttribute(DisplayAttributeType displayAttributeType, Enum<?> enumValue) {
        this.setDisplayAttribute(displayAttributeType, ValueType.STRING, enumValue.toString());
    }

    default public EnumMap<DisplayAttributeType, DisplayAttributeEntry> createDefaultDisplayAttributeMap() {
        EnumMap<DisplayAttributeType, DisplayAttributeEntry> map = new EnumMap<DisplayAttributeType, DisplayAttributeEntry>(DisplayAttributeType.class);
        map.put(DisplayAttributeType.LIGHT_LEVEL, new DisplayAttributeEntry(7));
        map.put(DisplayAttributeType.VISIBLE, new DisplayAttributeEntry(true));
        map.put(DisplayAttributeType.VISIBLE_AT_DAY, new DisplayAttributeEntry(true));
        map.put(DisplayAttributeType.VISIBLE_AT_NIGHT, new DisplayAttributeEntry(true));
        map.put(DisplayAttributeType.VISIBLE_IN_CREATIVE, new DisplayAttributeEntry(true));
        map.put(DisplayAttributeType.VISIBLE_IN_SPECTATOR, new DisplayAttributeEntry(true));
        map.put(DisplayAttributeType.VISIBLE_IN_STANDARD, new DisplayAttributeEntry(true));
        map.put(DisplayAttributeType.VISIBLE_TO_OWNER, new DisplayAttributeEntry(true));
        map.put(DisplayAttributeType.VISIBLE_TO_TEAM, new DisplayAttributeEntry(true));
        map.put(DisplayAttributeType.NAME_VISIBILITY, new DisplayAttributeEntry(NameVisibilityType.ALWAYS.toString()));
        return map;
    }

    default public void defineSynchedDisplayAttributeData(class_2945.class_9222 builder) {
        this.defineSynchedEntityData(builder, SynchedDataIndex.DISPLAY_ATTRIBUTE_SET, this.createDefaultDisplayAttributeMap());
    }

    default public void readAdditionalDisplayAttributeData(class_2487 compoundTag) {
        if (!compoundTag.method_10545(DATA_DISPLAY_ATTRIBUTE_SET_TAG)) {
            return;
        }
        class_2499 displayListTag = compoundTag.method_68569(DATA_DISPLAY_ATTRIBUTE_SET_TAG);
        EnumMap<DisplayAttributeType, DisplayAttributeEntry> displayAttributeMap = new EnumMap<DisplayAttributeType, DisplayAttributeEntry>(DisplayAttributeType.class);
        displayListTag.forEach(entry -> {
            if (entry instanceof class_2487) {
                class_2487 entryCompoundTag = (class_2487)entry;
                if (entryCompoundTag.method_10545("Type")) {
                    String typeString = entryCompoundTag.method_10558("Type").orElse("");
                    DisplayAttributeType displayAttributeType = DisplayAttributeType.get(typeString);
                    if (displayAttributeType != DisplayAttributeType.NONE) {
                        DisplayAttributeEntry displayAttributeEntry = new DisplayAttributeEntry(entryCompoundTag);
                        displayAttributeMap.put(displayAttributeType, displayAttributeEntry);
                    } else {
                        log.warn("Skip invalid display attribute type {}", (Object)typeString);
                    }
                } else {
                    log.warn("Skip display attribute entry without type information");
                }
            } else {
                log.error("Failed to load display attribute entry from {}", entry);
            }
        });
        this.setDisplayAttributeMap(displayAttributeMap);
    }

    default public void addAdditionalDisplayAttributeData(class_2487 compoundTag) {
        EnumMap<DisplayAttributeType, DisplayAttributeEntry> displayAttributeMap = this.getDisplayAttributeMap();
        if (displayAttributeMap != null && !displayAttributeMap.isEmpty()) {
            class_2499 displayListTag = new class_2499();
            displayAttributeMap.entrySet().stream().filter(mapEntry -> mapEntry.getKey() != DisplayAttributeType.NONE).forEach(mapEntry -> {
                class_2487 entryTag = new class_2487();
                entryTag.method_10582("Type", ((DisplayAttributeType)((Object)((Object)mapEntry.getKey()))).name());
                ((DisplayAttributeEntry)mapEntry.getValue()).write(entryTag);
                displayListTag.add((Object)entryTag);
            });
            compoundTag.method_10566(DATA_DISPLAY_ATTRIBUTE_SET_TAG, (class_2520)displayListTag);
        }
    }
}

