/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.handler;

import de.markusbordihn.easynpc.data.attribute.CombatAttributeType;
import de.markusbordihn.easynpc.data.attribute.CombatAttributes;
import de.markusbordihn.easynpc.data.attribute.EntityAttribute;
import de.markusbordihn.easynpc.data.attribute.EntityAttributes;
import de.markusbordihn.easynpc.data.attribute.EnvironmentalAttributeType;
import de.markusbordihn.easynpc.data.attribute.EnvironmentalAttributes;
import de.markusbordihn.easynpc.data.attribute.InteractionAttributeType;
import de.markusbordihn.easynpc.data.attribute.InteractionAttributes;
import de.markusbordihn.easynpc.data.attribute.MovementAttributeType;
import de.markusbordihn.easynpc.data.attribute.MovementAttributes;
import de.markusbordihn.easynpc.data.display.DisplayAttributeType;
import de.markusbordihn.easynpc.data.type.ValueType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.AttributeDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.DisplayAttributeDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.NavigationDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.ObjectiveDataCapable;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1320;
import net.minecraft.class_5134;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AttributeHandler {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    private AttributeHandler() {
    }

    public static boolean setCombatAttribute(EasyNPC<?> easyNPC, CombatAttributeType attributeType, ValueType valueType, Object value) {
        if (valueType == ValueType.BOOLEAN && value instanceof Boolean) {
            Boolean booleanValue = (Boolean)value;
            return AttributeHandler.setCombatAttribute(easyNPC, attributeType, booleanValue);
        }
        if (valueType == ValueType.DOUBLE && value instanceof Double) {
            Double doubleValue = (Double)value;
            return AttributeHandler.setCombatAttribute(easyNPC, attributeType, doubleValue);
        }
        return false;
    }

    public static boolean setCombatAttribute(EasyNPC<?> easyNPC, CombatAttributeType attributeType, boolean value) {
        if (easyNPC == null || attributeType == null) {
            return false;
        }
        AttributeDataCapable attributeData = easyNPC.getEasyNPCAttributeData();
        if (attributeData == null || attributeData.getEntityAttributes() == null) {
            return false;
        }
        EntityAttributes entityAttributes = attributeData.getEntityAttributes();
        CombatAttributes attributes = entityAttributes.getCombatAttributes();
        log.debug("Changing combat attribute {}={} for {}", (Object)attributeType, (Object)value, easyNPC);
        switch (attributeType) {
            case IS_INVULNERABLE: {
                entityAttributes.setCombatAttributes(attributes.withIsInvulnerable(value));
                break;
            }
            case IS_ATTACKABLE_BY_PLAYERS: {
                entityAttributes.setCombatAttributes(attributes.withIsAttackableByPlayers(value));
                break;
            }
            case IS_ATTACKABLE_BY_MONSTERS: {
                entityAttributes.setCombatAttributes(attributes.withIsAttackableByMonsters(value));
                break;
            }
            default: {
                log.error("Unimplemented combat attribute {} for {}", (Object)attributeType, easyNPC);
                return false;
            }
        }
        attributeData.refreshEntityAttributes();
        return true;
    }

    public static boolean setCombatAttribute(EasyNPC<?> easyNPC, CombatAttributeType attributeType, double value) {
        if (easyNPC == null || attributeType == null) {
            return false;
        }
        AttributeDataCapable attributeData = easyNPC.getEasyNPCAttributeData();
        if (attributeData == null || attributeData.getEntityAttributes() == null) {
            return false;
        }
        EntityAttributes entityAttributes = attributeData.getEntityAttributes();
        CombatAttributes attributes = entityAttributes.getCombatAttributes();
        log.debug("Changing combat attribute {}={} for {}", (Object)attributeType, (Object)value, easyNPC);
        switch (attributeType) {
            case HEALTH_REGENERATION: {
                entityAttributes.setCombatAttributes(attributes.withHealthRegeneration(value));
                break;
            }
            default: {
                log.error("Unimplemented combat attribute {} for {}", (Object)attributeType, easyNPC);
                return false;
            }
        }
        attributeData.refreshEntityAttributes();
        return true;
    }

    public static <T> boolean setDisplayAttribute(EasyNPC<?> easyNPC, DisplayAttributeType attributeType, T value) {
        if (easyNPC == null || attributeType == null) {
            return false;
        }
        DisplayAttributeDataCapable attributeData = easyNPC.getEasyNPCDisplayAttributeData();
        if (attributeData == null) {
            return false;
        }
        log.debug("Changing display attribute {}={} for {}", (Object)attributeType, value, easyNPC);
        ValueType valueType = attributeType.getValueType();
        attributeData.setDisplayAttribute(attributeType, valueType, value);
        return true;
    }

    public static boolean setEnvironmentalAttribute(EasyNPC<?> easyNPC, EnvironmentalAttributeType attributeType, boolean value) {
        if (easyNPC == null || attributeType == null) {
            return false;
        }
        AttributeDataCapable attributeData = easyNPC.getEasyNPCAttributeData();
        if (attributeData == null || attributeData.getEntityAttributes() == null) {
            return false;
        }
        EntityAttributes entityAttributes = attributeData.getEntityAttributes();
        EnvironmentalAttributes attributes = entityAttributes.getEnvironmentalAttributes();
        ObjectiveDataCapable objectiveData = easyNPC.getEasyNPCObjectiveData();
        NavigationDataCapable navigationData = easyNPC.getEasyNPCNavigationData();
        log.debug("Changing environmental attribute {}={} for {}", (Object)attributeType, (Object)value, easyNPC);
        switch (attributeType) {
            case CAN_BREATHE_UNDERWATER: {
                entityAttributes.setEnvironmentalAttributes(attributes.withCanBreathUnderwater(value));
                break;
            }
            case CAN_FLOAT: {
                entityAttributes.setEnvironmentalAttributes(attributes.withCanFloat(value));
                if (objectiveData != null) {
                    objectiveData.registerAttributeBasedObjectives();
                }
                if (navigationData == null) break;
                navigationData.refreshGroundNavigation();
                break;
            }
            case FREEFALL: {
                entityAttributes.setEnvironmentalAttributes(attributes.withFreefall(value));
                break;
            }
            case NO_GRAVITY: {
                entityAttributes.setEnvironmentalAttributes(attributes.withNoGravity(value));
                if (easyNPC.getLivingEntity() == null) break;
                easyNPC.getLivingEntity().method_5875(value);
                if (!value) break;
                easyNPC.getLivingEntity().method_18799(easyNPC.getLivingEntity().method_18798().method_18805(1.0, 0.0, 1.0));
                break;
            }
            default: {
                log.error("Unimplemented environmental attribute {} for {}", (Object)attributeType, easyNPC);
                return false;
            }
        }
        attributeData.refreshEntityAttributes();
        return true;
    }

    public static boolean setInteractionAttribute(EasyNPC<?> easyNPC, InteractionAttributeType attributeType, boolean value) {
        if (easyNPC == null || attributeType == null) {
            return false;
        }
        AttributeDataCapable attributeData = easyNPC.getEasyNPCAttributeData();
        if (attributeData == null || attributeData.getEntityAttributes() == null) {
            return false;
        }
        EntityAttributes entityAttributes = attributeData.getEntityAttributes();
        InteractionAttributes attributes = entityAttributes.getInteractionAttributes();
        log.debug("Changing interaction attribute {}={} for {}", (Object)attributeType, (Object)value, easyNPC);
        switch (attributeType) {
            case CAN_BE_LEASHED: {
                entityAttributes.setInteractionAttributes(attributes.withCanBeLeashed(value));
                break;
            }
            case IS_PUSHABLE: {
                entityAttributes.setInteractionAttributes(attributes.withIsPushable(value));
                break;
            }
            case PUSH_ENTITIES: {
                entityAttributes.setInteractionAttributes(attributes.withPushEntities(value));
                break;
            }
            default: {
                log.error("Unimplemented interaction attribute {} for {}", (Object)attributeType, easyNPC);
                return false;
            }
        }
        attributeData.refreshEntityAttributes();
        return true;
    }

    public static boolean setMovementAttribute(EasyNPC<?> easyNPC, MovementAttributeType attributeType, boolean value) {
        if (easyNPC == null || attributeType == null) {
            return false;
        }
        AttributeDataCapable attributeData = easyNPC.getEasyNPCAttributeData();
        if (attributeData == null || attributeData.getEntityAttributes() == null) {
            return false;
        }
        EntityAttributes entityAttributes = attributeData.getEntityAttributes();
        MovementAttributes attributes = entityAttributes.getMovementAttributes();
        ObjectiveDataCapable objectiveData = easyNPC.getEasyNPCObjectiveData();
        NavigationDataCapable navigationData = easyNPC.getEasyNPCNavigationData();
        log.debug("Changing moving attribute {}={} for {}", (Object)attributeType, (Object)value, easyNPC);
        switch (attributeType) {
            case CAN_CLOSE_DOOR: {
                entityAttributes.setMovementAttributes(attributes.withCanCloseDoor(value));
                break;
            }
            case CAN_OPEN_DOOR: {
                entityAttributes.setMovementAttributes(attributes.withCanOpenDoor(value));
                break;
            }
            case CAN_PASS_DOOR: {
                entityAttributes.setMovementAttributes(attributes.withCanPassDoor(value));
                break;
            }
            case CAN_USE_NETHER_PORTAL: {
                entityAttributes.setMovementAttributes(attributes.withCanUseNetherPortal(value));
                break;
            }
            default: {
                log.error("Unimplemented moving attribute {} for {}", (Object)attributeType, easyNPC);
                return false;
            }
        }
        attributeData.refreshEntityAttributes();
        if (objectiveData != null) {
            objectiveData.registerAttributeBasedObjectives();
        }
        if (navigationData != null) {
            navigationData.refreshGroundNavigation();
        }
        return true;
    }

    public static boolean setEntityAttribute(EasyNPC<?> easyNPC, EntityAttribute entityAttribute, boolean value) {
        if (easyNPC == null || entityAttribute == null) {
            return false;
        }
        AttributeDataCapable attributeData = easyNPC.getEasyNPCAttributeData();
        if (attributeData != null) {
            ObjectiveDataCapable objectiveData = easyNPC.getEasyNPCObjectiveData();
            NavigationDataCapable navigationData = easyNPC.getEasyNPCNavigationData();
            switch (entityAttribute) {
                case SILENT: {
                    log.debug("Change silent={} for {}", (Object)value, easyNPC);
                    attributeData.setAttributeSilent(value);
                    break;
                }
                default: {
                    log.error("Unimplemented entity attribute {} for {}", (Object)entityAttribute, easyNPC);
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static boolean setBaseAttribute(EasyNPC<?> easyNPC, class_1320 attribute, Double value) {
        if (easyNPC == null || attribute == null || value == null) {
            return false;
        }
        AttributeDataCapable attributeData = easyNPC.getEasyNPCAttributeData();
        if (attributeData != null) {
            if (attribute == class_5134.field_23716.comp_349()) {
                attributeData.setBaseAttribute((class_6880<class_1320>)class_5134.field_23716, value);
                class_1309 livingEntity = easyNPC.getLivingEntity();
                if (livingEntity != null) {
                    livingEntity.method_6033(value.floatValue());
                }
            } else if (attribute == class_5134.field_23717.comp_349() || attribute == class_5134.field_23718.comp_349() || attribute == class_5134.field_23719.comp_349() || attribute == class_5134.field_23720.comp_349() || attribute == class_5134.field_23721.comp_349() || attribute == class_5134.field_23722.comp_349() || attribute == class_5134.field_23723.comp_349() || attribute == class_5134.field_23724.comp_349() || attribute == class_5134.field_23725.comp_349() || attribute == class_5134.field_23726.comp_349()) {
                class_6880 attributeHolder = class_7923.field_41190.method_47983((Object)attribute);
                attributeData.setBaseAttribute((class_6880<class_1320>)attributeHolder, value);
            } else {
                log.error("Unsupported base attribute {} for {}", (Object)attribute, easyNPC);
                return false;
            }
            return true;
        }
        log.error("Missing attribute data for {}", easyNPC);
        return false;
    }

    public static void handleDefaultAttributes(class_1314 pathfinderMob) {
        if (pathfinderMob == null) {
            return;
        }
        if (pathfinderMob.method_5996(class_5134.field_23727) != null) {
            pathfinderMob.method_5996(class_5134.field_23727).method_6192(0.0);
        }
    }
}

