/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.handler;

import de.markusbordihn.easynpc.data.display.DisplayAttributeType;
import de.markusbordihn.easynpc.data.display.NameVisibilityType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.DisplayAttributeDataCapable;
import de.markusbordihn.easynpc.network.components.TextComponent;
import de.markusbordihn.easynpc.utils.TextUtils;
import net.minecraft.class_1297;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5251;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NameHandler {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    private NameHandler() {
    }

    public static boolean setCustomName(EasyNPC<?> easyNPC, String name, int color, boolean visible) {
        return NameHandler.setCustomName(easyNPC, name, color, visible ? NameVisibilityType.ALWAYS : NameVisibilityType.NEVER);
    }

    public static boolean setCustomName(EasyNPC<?> easyNPC, String name, int color, NameVisibilityType nameVisibilityType) {
        if (easyNPC == null || name == null) {
            log.error("[{}] Error setting custom name {}", easyNPC, (Object)name);
            return false;
        }
        class_1297 entity = easyNPC.getEntity();
        log.debug("[{}] Change custom name to '{}' with color {} and visibility {}", easyNPC, (Object)name, (Object)color, (Object)nameVisibilityType);
        if (name.isEmpty()) {
            log.debug("[{}] Remove custom name", easyNPC);
            entity.method_5665(null);
            entity.method_5880(false);
            return true;
        }
        class_2583 style = class_2583.field_24360;
        if (color >= 0) {
            style = style.method_27703(class_5251.method_27717((int)color));
        }
        entity.method_5665((class_2561)TextComponent.getTextComponentRaw(name, TextUtils.isTranslationKey(name)).method_10862(style));
        entity.method_5880(nameVisibilityType != NameVisibilityType.NEVER);
        DisplayAttributeDataCapable displayAttributeData = easyNPC.getEasyNPCDisplayAttributeData();
        if (displayAttributeData != null) {
            displayAttributeData.setDisplayAttribute(DisplayAttributeType.NAME_VISIBILITY, nameVisibilityType);
        }
        return true;
    }
}

